/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.net.URI;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.SecurityActions;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.client.hotrod.configuration.StatisticsConfiguration;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.counter.impl.RemoteCounterManager;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.HotRodURI;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.InvalidatedNearRemoteCache;
import org.infinispan.client.hotrod.impl.MarshallerRegistry;
import org.infinispan.client.hotrod.impl.RemoteCacheImpl;
import org.infinispan.client.hotrod.impl.RemoteCacheManagerAdminImpl;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transaction.SyncModeTransactionTable;
import org.infinispan.client.hotrod.impl.transaction.TransactionOperationFactory;
import org.infinispan.client.hotrod.impl.transaction.TransactionTable;
import org.infinispan.client.hotrod.impl.transaction.TransactionalRemoteCacheImpl;
import org.infinispan.client.hotrod.impl.transaction.XaModeTransactionTable;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.jmx.RemoteCacheManagerMXBean;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.marshall.BytesOnlyMarshaller;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.commons.time.DefaultTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.Version;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;

public class RemoteCacheManager
implements RemoteCacheContainer,
Closeable,
RemoteCacheManagerMXBean {
    private static final Log log = LogFactory.getLog(RemoteCacheManager.class);
    public static final String HOTROD_CLIENT_PROPERTIES = "hotrod-client.properties";
    public static final String JSON_STRING_ARRAY_ELEMENT_REGEX = "(?:\")([^\"]*)(?:\",?)";
    private volatile boolean started = false;
    private final Map<RemoteCacheKey, RemoteCacheHolder> cacheName2RemoteCache = new HashMap<RemoteCacheKey, RemoteCacheHolder>();
    private final MarshallerRegistry marshallerRegistry = new MarshallerRegistry();
    private final AtomicInteger defaultCacheTopologyId = new AtomicInteger(-1);
    private Configuration configuration;
    private Codec codec;
    private Marshaller marshaller;
    protected ChannelFactory channelFactory;
    protected ClientListenerNotifier listenerNotifier;
    private final Runnable start = this::start;
    private final Runnable stop = this::stop;
    private final RemoteCounterManager counterManager;
    private final TransactionTable syncTransactionTable;
    private final XaModeTransactionTable xaTransactionTable;
    private ObjectName mbeanObjectName;
    private TimeService timeService = DefaultTimeService.INSTANCE;
    private ExecutorService asyncExecutorService;

    public RemoteCacheManager(Configuration configuration) {
        this(configuration, true);
    }

    public RemoteCacheManager(String uri) {
        this(HotRodURI.create(uri));
    }

    public RemoteCacheManager(URI uri) {
        this(HotRodURI.create(uri));
    }

    private RemoteCacheManager(HotRodURI uri) {
        this(uri.toConfigurationBuilder().build());
    }

    public RemoteCacheManager(Configuration configuration, boolean start) {
        this.configuration = configuration;
        this.counterManager = new RemoteCounterManager();
        this.syncTransactionTable = new SyncModeTransactionTable(configuration.transaction().timeout());
        this.xaTransactionTable = new XaModeTransactionTable(configuration.transaction().timeout());
        this.registerMBean();
        if (start) {
            this.start();
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteCacheManager(boolean start) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        builder.classLoader(cl);
        InputStream stream = FileLookupFactory.newInstance().lookupFile(HOTROD_CLIENT_PROPERTIES, cl);
        if (stream == null) {
            Log.HOTROD.couldNotFindPropertiesFile(HOTROD_CLIENT_PROPERTIES);
        } else {
            try {
                builder.withProperties(this.loadFromStream(stream));
            }
            finally {
                org.infinispan.commons.util.Util.close((AutoCloseable)stream);
            }
        }
        this.configuration = builder.build();
        this.counterManager = new RemoteCounterManager();
        this.syncTransactionTable = new SyncModeTransactionTable(this.configuration.transaction().timeout());
        this.xaTransactionTable = new XaModeTransactionTable(this.configuration.transaction().timeout());
        this.registerMBean();
        if (start) {
            this.actualStart();
        }
    }

    public RemoteCacheManager() {
        this(true);
    }

    private void registerMBean() {
        StatisticsConfiguration configuration = this.configuration.statistics();
        if (configuration.jmxEnabled()) {
            try {
                MBeanServer mbeanServer = configuration.mbeanServerLookup().getMBeanServer();
                this.mbeanObjectName = new ObjectName(String.format("%s:type=HotRodClient,name=%s", configuration.jmxDomain(), configuration.jmxName()));
                mbeanServer.registerMBean(this, this.mbeanObjectName);
            }
            catch (Exception e) {
                throw Log.HOTROD.jmxRegistrationFailure(e);
            }
        }
    }

    private void unregisterMBean() {
        if (this.mbeanObjectName != null) {
            try {
                MBeanServer mBeanServer = this.configuration.statistics().mbeanServerLookup().getMBeanServer();
                if (mBeanServer.isRegistered(this.mbeanObjectName)) {
                    mBeanServer.unregisterMBean(this.mbeanObjectName);
                } else {
                    Log.HOTROD.debugf("MBean not registered: %s", this.mbeanObjectName);
                }
            }
            catch (Exception e) {
                throw Log.HOTROD.jmxUnregistrationFailure(e);
            }
        }
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName) {
        return this.getCache(cacheName, this.configuration.forceReturnValues(), null, null);
    }

    public Set<String> getCacheNames() {
        OperationsFactory operationsFactory = new OperationsFactory(this.channelFactory, this.codec, this.listenerNotifier, this.configuration);
        String names = (String)Util.await(operationsFactory.newAdminOperation("@@cache@names", Collections.emptyMap()).execute());
        HashSet<String> cacheNames = new HashSet<String>();
        Pattern pattern = Pattern.compile(JSON_STRING_ARRAY_ELEMENT_REGEX);
        Matcher matcher = pattern.matcher(names);
        while (matcher.find()) {
            cacheNames.add(matcher.group(1));
        }
        return cacheNames;
    }

    public <K, V> RemoteCache<K, V> getCache() {
        return this.getCache(this.configuration.forceReturnValues());
    }

    @Override
    public <K, V> RemoteCache<K, V> getCache(String cacheName, TransactionMode transactionMode, TransactionManager transactionManager) {
        return this.createRemoteCache(cacheName, this.configuration.forceReturnValues(), transactionMode, transactionManager);
    }

    @Override
    public <K, V> RemoteCache<K, V> getCache(String cacheName, boolean forceReturnValue, TransactionMode transactionMode, TransactionManager transactionManager) {
        return this.createRemoteCache(cacheName, forceReturnValue, transactionMode, transactionManager);
    }

    public CompletableFuture<Void> startAsync() {
        return CompletableFuture.runAsync(this.start, ForkJoinPool.commonPool());
    }

    public CompletableFuture<Void> stopAsync() {
        return CompletableFuture.runAsync(this.stop, ForkJoinPool.commonPool());
    }

    public void start() {
        if (!this.started) {
            this.actualStart();
        }
    }

    private void actualStart() {
        log.debugf("Starting remote cache manager %x", System.identityHashCode(this));
        this.channelFactory = this.createChannelFactory();
        if (this.marshaller == null) {
            this.marshaller = this.configuration.marshaller();
            if (this.marshaller == null) {
                Class<? extends Marshaller> clazz = this.configuration.marshallerClass();
                if (this.marshaller == null) {
                    this.marshaller = (Marshaller)org.infinispan.commons.util.Util.getInstance(clazz);
                }
            }
        }
        if (!this.configuration.serialWhitelist().isEmpty()) {
            this.marshaller.initialize(this.configuration.getClassWhiteList());
        }
        if (this.marshaller instanceof ProtoStreamMarshaller) {
            SerializationContext ctx = ((ProtoStreamMarshaller)this.marshaller).getSerializationContext();
            for (SerializationContextInitializer sci : this.configuration.getContextInitializers()) {
                sci.registerSchema(ctx);
                sci.registerMarshallers(ctx);
            }
        }
        this.marshallerRegistry.registerMarshaller(BytesOnlyMarshaller.INSTANCE);
        this.marshallerRegistry.registerMarshaller((Marshaller)new UTF8StringMarshaller());
        this.marshallerRegistry.registerMarshaller(this.marshaller);
        this.codec = this.configuration.version().getCodec();
        this.listenerNotifier = new ClientListenerNotifier(this.codec, this.marshaller, this.channelFactory, this.configuration);
        ExecutorFactory executorFactory = this.configuration.asyncExecutorFactory().factory();
        if (executorFactory == null) {
            executorFactory = (ExecutorFactory)org.infinispan.commons.util.Util.getInstance(this.configuration.asyncExecutorFactory().factoryClass());
        }
        this.asyncExecutorService = executorFactory.getExecutor((Properties)this.configuration.asyncExecutorFactory().properties());
        this.channelFactory.start(this.codec, this.configuration, this.defaultCacheTopologyId, this.marshaller, this.asyncExecutorService, this.listenerNotifier, Collections.singletonList(this.listenerNotifier::failoverListeners), this.marshallerRegistry);
        this.counterManager.start(this.channelFactory, this.codec, this.configuration, this.listenerNotifier);
        TransactionOperationFactory txOperationFactory = new TransactionOperationFactory(this.configuration, this.channelFactory, this.codec);
        this.syncTransactionTable.start(txOperationFactory);
        this.xaTransactionTable.start(txOperationFactory);
        Log.HOTROD.version(Version.printVersion());
        this.started = true;
    }

    public ChannelFactory createChannelFactory() {
        return new ChannelFactory();
    }

    @Override
    public boolean isTransactional(String cacheName) {
        ClientStatistics stats = ClientStatistics.dummyClientStatistics(this.timeService);
        OperationsFactory factory = this.createOperationFactory(cacheName, false, this.codec, stats);
        return Util.checkTransactionSupport(cacheName, factory, log);
    }

    public MarshallerRegistry getMarshallerRegistry() {
        return this.marshallerRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isStarted()) {
            log.debugf("Stopping remote cache manager %x", System.identityHashCode(this));
            Map<RemoteCacheKey, RemoteCacheHolder> map = this.cacheName2RemoteCache;
            synchronized (map) {
                for (Map.Entry<RemoteCacheKey, RemoteCacheHolder> cache : this.cacheName2RemoteCache.entrySet()) {
                    cache.getValue().remoteCache().stop();
                }
                this.cacheName2RemoteCache.clear();
            }
            this.listenerNotifier.stop();
            this.counterManager.stop();
            this.channelFactory.destroy();
        }
        this.unregisterMBean();
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean switchToCluster(String clusterName) {
        return this.channelFactory.switchToCluster(clusterName);
    }

    @Override
    public boolean switchToDefaultCluster() {
        return this.channelFactory.switchToCluster("___DEFAULT-CLUSTER___");
    }

    private Properties loadFromStream(InputStream stream) {
        Properties properties = new Properties();
        try {
            properties.load(stream);
        }
        catch (IOException e) {
            throw new HotRodClientException("Issues configuring from client hotrod-client.properties", e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> RemoteCache<K, V> createRemoteCache(String cacheName, boolean forceReturnValueOverride, TransactionMode transactionModeOverride, TransactionManager transactionManagerOverride) {
        InternalRemoteCache<K, V> remoteCache;
        TransactionMode transactionMode;
        PingResponse pingResponse;
        RemoteCacheConfiguration cacheConfiguration = this.configuration.remoteCaches().get(cacheName);
        boolean forceReturnValue = forceReturnValueOverride ? true : (cacheConfiguration != null ? cacheConfiguration.forceReturnValues() : this.configuration.forceReturnValues());
        RemoteCacheKey key = new RemoteCacheKey(cacheName, forceReturnValue);
        if (this.cacheName2RemoteCache.containsKey(key)) {
            return this.cacheName2RemoteCache.get(key).remoteCache();
        }
        OperationsFactory operationsFactory = this.createOperationFactory(cacheName, forceReturnValue, this.codec, null);
        if (this.started) {
            pingResponse = (PingResponse)Util.await(operationsFactory.newFaultTolerantPingOperation().execute());
            if (pingResponse.isCacheNotFound()) {
                HashMap<String, byte[]> params = new HashMap<String, byte[]>(2);
                params.put("name", cacheName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
                if (cacheConfiguration != null && cacheConfiguration.templateName() != null) {
                    params.put("template", cacheConfiguration.templateName().getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
                } else if (cacheConfiguration != null && cacheConfiguration.configuration() != null) {
                    params.put("configuration", new XMLStringConfiguration(cacheConfiguration.configuration()).toXMLString(cacheName).getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
                } else {
                    return null;
                }
                OperationsFactory adminOperationsFactory = new OperationsFactory(this.channelFactory, this.codec, this.listenerNotifier, this.configuration);
                pingResponse = (PingResponse)Util.await(adminOperationsFactory.newAdminOperation("@@cache@getorcreate", params).execute().thenCompose(s -> operationsFactory.newFaultTolerantPingOperation().execute()));
            }
        } else {
            pingResponse = PingResponse.EMPTY;
        }
        if ((transactionMode = this.getTransactionMode(transactionModeOverride)) == TransactionMode.NONE) {
            remoteCache = this.createRemoteCache(cacheName);
        } else {
            if (!Util.await(Util.checkTransactionSupport(cacheName, operationsFactory).toCompletableFuture()).booleanValue()) {
                throw Log.HOTROD.cacheDoesNotSupportTransactions(cacheName);
            }
            TransactionManager transactionManager = this.getTransactionManager(transactionManagerOverride);
            remoteCache = this.createRemoteTransactionalCache(cacheName, forceReturnValueOverride, transactionMode == TransactionMode.FULL_XA, transactionMode, transactionManager);
        }
        Map<RemoteCacheKey, RemoteCacheHolder> map = this.cacheName2RemoteCache;
        synchronized (map) {
            this.startRemoteCache(remoteCache, operationsFactory.getCodec(), forceReturnValue);
            RemoteCacheHolder holder = new RemoteCacheHolder(remoteCache, forceReturnValueOverride);
            remoteCache.resolveStorage(pingResponse.isObjectStorage());
            this.cacheName2RemoteCache.putIfAbsent(key, holder);
            return remoteCache;
        }
    }

    private <K, V> InternalRemoteCache<K, V> createRemoteCache(String cacheName) {
        Pattern pattern;
        RemoteCacheConfiguration remoteCacheConfiguration = this.configuration.remoteCaches().get(cacheName);
        NearCacheConfiguration nearCache = remoteCacheConfiguration != null ? new NearCacheConfiguration(remoteCacheConfiguration.nearCacheMode(), remoteCacheConfiguration.nearCacheMaxEntries()) : ((pattern = this.configuration.nearCache().cacheNamePattern()) == null || pattern.matcher(cacheName).matches() ? this.configuration.nearCache() : new NearCacheConfiguration(NearCacheMode.DISABLED, -1));
        if (nearCache.mode() == NearCacheMode.INVALIDATED && ((pattern = nearCache.cacheNamePattern()) == null || pattern.matcher(cacheName).matches())) {
            if (log.isTraceEnabled()) {
                log.tracef("Enabling near-caching for cache '%s'", cacheName);
            }
            NearCacheService<K, V> nearCacheService = this.createNearCacheService(cacheName, nearCache);
            return InvalidatedNearRemoteCache.delegatingNearCache(new RemoteCacheImpl<K, V>(this, cacheName, this.timeService, nearCacheService), nearCacheService);
        }
        return new RemoteCacheImpl(this, cacheName, this.timeService);
    }

    protected <K, V> NearCacheService<K, V> createNearCacheService(String cacheName, NearCacheConfiguration cfg) {
        return this.createNearCacheService(cfg);
    }

    @Deprecated
    protected <K, V> NearCacheService<K, V> createNearCacheService(NearCacheConfiguration cfg) {
        return NearCacheService.create(cfg, this.listenerNotifier);
    }

    private void startRemoteCache(InternalRemoteCache<?, ?> remoteCache, Codec codec, boolean forceReturnValue) {
        OperationsFactory operationsFactory = this.createOperationFactory(remoteCache.getName(), forceReturnValue, codec, remoteCache.clientStatistics());
        this.initRemoteCache(remoteCache, operationsFactory);
        remoteCache.start();
    }

    private void initRemoteCache(InternalRemoteCache<?, ?> remoteCache, OperationsFactory operationsFactory) {
        if (this.configuration.statistics().jmxEnabled()) {
            remoteCache.init(this.marshaller, operationsFactory, this.configuration, this.mbeanObjectName);
        } else {
            remoteCache.init(this.marshaller, operationsFactory, this.configuration);
        }
    }

    @Override
    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public static byte[] cacheNameBytes(String cacheName) {
        return cacheName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET);
    }

    public static byte[] cacheNameBytes() {
        return HotRodConstants.DEFAULT_CACHE_NAME_BYTES;
    }

    public RemoteCacheManagerAdmin administration() {
        OperationsFactory operationsFactory = new OperationsFactory(this.channelFactory, this.codec, this.listenerNotifier, this.configuration);
        return new RemoteCacheManagerAdminImpl(this, operationsFactory, EnumSet.noneOf(CacheContainerAdmin.AdminFlag.class), name -> {
            Map<RemoteCacheKey, RemoteCacheHolder> map = this.cacheName2RemoteCache;
            synchronized (map) {
                this.cacheName2RemoteCache.remove(new RemoteCacheKey((String)name, true));
                this.cacheName2RemoteCache.remove(new RemoteCacheKey((String)name, false));
            }
        });
    }

    @Override
    public void close() {
        this.stop();
    }

    CounterManager getCounterManager() {
        return this.counterManager;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public XAResource getXaResource() {
        return this.xaTransactionTable.getXaResource();
    }

    private TransactionManager getTransactionManager(TransactionManager override) {
        try {
            return override == null ? this.configuration.transaction().transactionManagerLookup().getTransactionManager() : override;
        }
        catch (Exception e) {
            throw new HotRodClientException(e);
        }
    }

    private TransactionMode getTransactionMode(TransactionMode override) {
        return override == null ? this.configuration.transaction().transactionMode() : override;
    }

    private TransactionTable getTransactionTable(TransactionMode transactionMode) {
        switch (transactionMode) {
            case NON_XA: {
                return this.syncTransactionTable;
            }
            case NON_DURABLE_XA: 
            case FULL_XA: {
                return this.xaTransactionTable;
            }
        }
        throw new IllegalStateException();
    }

    private <K, V> TransactionalRemoteCacheImpl<K, V> createRemoteTransactionalCache(String cacheName, boolean forceReturnValues, boolean recoveryEnabled, TransactionMode transactionMode, TransactionManager transactionManager) {
        return new TransactionalRemoteCacheImpl(this, cacheName, forceReturnValues, recoveryEnabled, transactionManager, this.getTransactionTable(transactionMode), this.timeService);
    }

    @Override
    public String[] getServers() {
        Collection<SocketAddress> addresses = this.channelFactory.getServers();
        return (String[])addresses.stream().map(Object::toString).toArray(String[]::new);
    }

    @Override
    public int getActiveConnectionCount() {
        return this.channelFactory.getNumActive();
    }

    @Override
    public int getConnectionCount() {
        return this.channelFactory.getNumActive() + this.channelFactory.getNumIdle();
    }

    @Override
    public int getIdleConnectionCount() {
        return this.channelFactory.getNumIdle();
    }

    @Override
    public long getRetries() {
        return this.channelFactory.getRetries();
    }

    private OperationsFactory createOperationFactory(String cacheName, boolean forceReturnValue, Codec codec, ClientStatistics stats) {
        return new OperationsFactory(this.channelFactory, cacheName, forceReturnValue, codec, this.listenerNotifier, this.configuration, stats);
    }

    public ExecutorService getAsyncExecutorService() {
        return this.asyncExecutorService;
    }

    static {
        for (String name : Arrays.asList("org.wildfly.security.sasl.plain.WildFlyElytronSaslPlainProvider", "org.wildfly.security.sasl.digest.WildFlyElytronSaslDigestProvider", "org.wildfly.security.sasl.external.WildFlyElytronSaslExternalProvider", "org.wildfly.security.sasl.oauth2.WildFlyElytronSaslOAuth2Provider", "org.wildfly.security.sasl.scram.WildFlyElytronSaslScramProvider", "org.wildfly.security.sasl.gssapi.WildFlyElytronSaslGssapiProvider", "org.wildfly.security.sasl.gs2.WildFlyElytronSaslGs2Provider")) {
            Provider provider = (Provider)org.infinispan.commons.util.Util.getInstance((String)name, (ClassLoader)RemoteCacheManager.class.getClassLoader());
            SecurityActions.addSecurityProvider(provider);
        }
    }

    private static class RemoteCacheHolder {
        final InternalRemoteCache<?, ?> remoteCache;
        final boolean forceReturnValue;

        RemoteCacheHolder(InternalRemoteCache<?, ?> remoteCache, boolean forceReturnValue) {
            this.remoteCache = remoteCache;
            this.forceReturnValue = forceReturnValue;
        }

        <K, V> InternalRemoteCache<K, V> remoteCache() {
            return this.remoteCache;
        }
    }

    private static class RemoteCacheKey {
        final String cacheName;
        final boolean forceReturnValue;

        RemoteCacheKey(String cacheName, boolean forceReturnValue) {
            this.cacheName = cacheName;
            this.forceReturnValue = forceReturnValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RemoteCacheKey)) {
                return false;
            }
            RemoteCacheKey that = (RemoteCacheKey)o;
            if (this.forceReturnValue != that.forceReturnValue) {
                return false;
            }
            return !(this.cacheName == null ? that.cacheName != null : !this.cacheName.equals(that.cacheName));
        }

        public int hashCode() {
            int result = this.cacheName != null ? this.cacheName.hashCode() : 0;
            result = 31 * result + (this.forceReturnValue ? 1 : 0);
            return result;
        }
    }
}

