/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.query;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.Util;
import org.infinispan.client.hotrod.impl.operations.QueryOperation;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.remote.client.impl.BaseQueryResponse;

public final class RemoteQuery<T>
extends BaseQuery<T> {
    private final InternalRemoteCache<?, ?> cache;
    private final SerializationContext serializationContext;
    private final IndexedQueryMode indexedQueryMode;

    RemoteQuery(QueryFactory queryFactory, InternalRemoteCache<?, ?> cache, SerializationContext serializationContext, String queryString, IndexedQueryMode indexQueryMode) {
        super(queryFactory, queryString);
        this.cache = cache;
        this.serializationContext = serializationContext;
        this.indexedQueryMode = indexQueryMode;
    }

    RemoteQuery(QueryFactory queryFactory, InternalRemoteCache<?, ?> cache, SerializationContext serializationContext, String queryString, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults) {
        super(queryFactory, queryString, namedParameters, projection, startOffset, maxResults);
        this.cache = cache;
        this.serializationContext = serializationContext;
        this.indexedQueryMode = null;
    }

    public void resetQuery() {
    }

    public List<T> list() {
        return this.execute().list();
    }

    public QueryResult<T> execute() {
        final BaseQueryResponse<T> response = this.executeQuery();
        return new QueryResult<T>(){

            public OptionalLong hitCount() {
                long totalResults = response.getTotalResults();
                return totalResults == -1L ? OptionalLong.empty() : OptionalLong.of(totalResults);
            }

            public List<T> list() {
                try {
                    return response.extractResults(RemoteQuery.this.serializationContext);
                }
                catch (IOException e) {
                    throw new HotRodClientException(e);
                }
            }
        };
    }

    public CloseableIterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    public int getResultSize() {
        BaseQueryResponse<T> response = this.executeQuery();
        return (int)response.getTotalResults();
    }

    private BaseQueryResponse<T> executeQuery() {
        this.validateNamedParameters();
        QueryOperation op = this.cache.getOperationsFactory().newQueryOperation(this, this.cache.getDataFormat());
        return (BaseQueryResponse)Util.await(op.execute());
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public RemoteCache<?, ?> getCache() {
        return this.cache;
    }

    public IndexedQueryMode getIndexedQueryMode() {
        return this.indexedQueryMode;
    }

    public String toString() {
        return "RemoteQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + '}';
    }
}

