/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.configuration;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.configuration.AbstractConfigurationChildBuilder;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionConfiguration;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.impl.ConfigurationProperties;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.Util;

public class TransactionConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<TransactionConfiguration> {
    public static final long DEFAULT_TIMEOUT = 60000L;
    private TransactionMode transactionMode = TransactionMode.NONE;
    private TransactionManagerLookup transactionManagerLookup = TransactionConfigurationBuilder.defaultTransactionManagerLookup();
    private long timeout = 60000L;

    TransactionConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public static TransactionManagerLookup defaultTransactionManagerLookup() {
        return GenericTransactionManagerLookup.getInstance();
    }

    public TransactionConfigurationBuilder transactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.transactionManagerLookup = transactionManagerLookup;
        return this;
    }

    public TransactionConfigurationBuilder transactionMode(TransactionMode transactionMode) {
        this.transactionMode = transactionMode;
        return this;
    }

    public TransactionConfigurationBuilder timeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeUnit.toMillis(timeout);
        return this;
    }

    public void validate() {
        if (this.transactionMode == null) {
            throw Log.HOTROD.invalidTransactionMode();
        }
        if (this.transactionManagerLookup == null) {
            throw Log.HOTROD.invalidTransactionManagerLookup();
        }
        if (this.timeout <= 0L) {
            throw Log.HOTROD.invalidTransactionTimeout();
        }
    }

    public TransactionConfiguration create() {
        return new TransactionConfiguration(this.transactionMode, this.transactionManagerLookup, this.timeout);
    }

    public Builder<?> read(TransactionConfiguration template) {
        this.transactionManagerLookup = template.transactionManagerLookup();
        this.transactionMode = template.transactionMode();
        this.timeout = template.timeout();
        return this;
    }

    void withTransactionProperties(Properties properties) {
        ConfigurationProperties cp = new ConfigurationProperties(properties);
        this.transactionMode = cp.getTransactionMode();
        String managerLookupClass = cp.getTransactionManagerLookup();
        if (managerLookupClass != null && !this.transactionManagerLookup.getClass().getName().equals(managerLookupClass)) {
            this.transactionManagerLookup = (TransactionManagerLookup)Util.getInstance((Class)Util.loadClass((String)managerLookupClass, (ClassLoader)this.builder.classLoader()));
        }
        this.timeout = cp.getTransactionTimeout();
    }
}

