/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl;

import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import javax.management.ObjectName;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.operations.OperationsFactory;
import org.infinispan.client.hotrod.impl.operations.PingResponse;
import org.infinispan.client.hotrod.impl.operations.RetryAwareCompletionStage;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.IntSet;

public interface InternalRemoteCache<K, V>
extends RemoteCache<K, V> {
    public CloseableIterator<K> keyIterator(IntSet var1);

    public CloseableIterator<Map.Entry<K, V>> entryIterator(IntSet var1);

    default public boolean removeEntry(Map.Entry<K, V> entry) {
        return this.removeEntry(entry.getKey(), entry.getValue());
    }

    default public boolean removeEntry(K key, V value) {
        MetadataValue versionedValue = this.getWithMetadata(key);
        return versionedValue != null && value.equals(versionedValue.getValue()) && this.removeWithVersion(key, versionedValue.getVersion());
    }

    public RetryAwareCompletionStage<MetadataValue<V>> getWithMetadataAsync(K var1, SocketAddress var2);

    @Override
    public InternalRemoteCache<K, V> withFlags(Flag ... var1);

    @Override
    public <T, U> InternalRemoteCache<T, U> withDataFormat(DataFormat var1);

    public boolean hasForceReturnFlag();

    public void resolveStorage(boolean var1);

    @Override
    public ClientStatistics clientStatistics();

    public void init(Marshaller var1, OperationsFactory var2, Configuration var3, ObjectName var4);

    public void init(Marshaller var1, OperationsFactory var2, Configuration var3);

    public OperationsFactory getOperationsFactory();

    public boolean isObjectStorage();

    public K keyAsObjectIfNeeded(Object var1);

    public byte[] keyToBytes(Object var1);

    public CompletionStage<PingResponse> ping();

    public SocketAddress addNearCacheListener(Object var1, int var2);

    public CompletionStage<Void> updateBloomFilter();
}

