/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.HotRodServerStartStopTest", groups={"functional"})
public class HotRodServerStartStopTest
extends MultipleCacheManagersTest {
    private HotRodServer hotRodServer1;
    private HotRodServer hotRodServer2;

    @AfterMethod
    protected void clearContent() {
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodServerStartStopTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        this.addClusterEnabledCacheManager(builder);
        this.addClusterEnabledCacheManager(builder);
        this.hotRodServer1 = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        this.hotRodServer2 = HotRodClientTestingUtil.startHotRodServer(this.manager(1));
        assert (this.manager(0).getCache() != null);
        assert (this.manager(1).getCache() != null);
        this.waitForClusterToForm();
    }

    public void testTouchServer() {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotRodServer1.getPort().intValue());
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(clientBuilder.build(), true);
        RemoteCache remoteCache = remoteCacheManager.getCache();
        remoteCache.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)remoteCache.get((Object)"k"));
        HotRodClientTestingUtil.killRemoteCacheManager(remoteCacheManager);
    }

    @Test(dependsOnMethods={"testTouchServer"})
    public void testHrServerStop() {
        HotRodClientTestingUtil.killServers(this.hotRodServer1, this.hotRodServer2);
        this.hotRodServer1 = null;
        this.hotRodServer2 = null;
    }
}

