/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.ClientListenerWithIndexingAndProtobufTest")
public class ClientListenerWithIndexingAndProtobufTest
extends MultiHotRodServersTest {
    private static final int NUM_NODES = 2;
    private RemoteCache<Object, Object> remoteCache;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cfgBuilder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)ClientListenerWithIndexingAndProtobufTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        cfgBuilder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("sample_bank_account.User");
        this.createHotRodServers(2, cfgBuilder);
        this.waitForClusterToForm();
        this.remoteCache = this.client(0).getCache();
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDomainSCI.INSTANCE;
    }

    public void testEventFilter() {
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        NoopEventListener listener = new NoopEventListener();
        this.remoteCache.addClientListener((Object)listener);
        this.expectElementsInQueue(listener.createEvents, 0);
        this.remoteCache.put((Object)("user_" + user1.getId()), (Object)user1);
        AssertJUnit.assertEquals((int)1, (int)this.remoteCache.size());
        this.expectElementsInQueue(listener.createEvents, 1);
        this.remoteCache.removeClientListener((Object)listener);
    }

    private void expectElementsInQueue(BlockingQueue<?> queue, int numElements) {
        for (int i = 0; i < numElements; ++i) {
            try {
                Object e = queue.poll(5L, TimeUnit.SECONDS);
                AssertJUnit.assertNotNull((String)"Queue was empty!", e);
                continue;
            }
            catch (InterruptedException e) {
                throw new AssertionError("Interrupted while waiting for condition", e);
            }
        }
        try {
            Object e = queue.poll(5L, TimeUnit.SECONDS);
            AssertJUnit.assertNull((String)"No more elements expected in queue!", e);
        }
        catch (InterruptedException e) {
            throw new AssertionError("Interrupted while waiting for condition", e);
        }
    }

    @ClientListener
    private static class NoopEventListener {
        public final BlockingQueue<ClientCacheEntryCreatedEvent> createEvents = new LinkedBlockingQueue<ClientCacheEntryCreatedEvent>();

        private NoopEventListener() {
        }

        @ClientCacheEntryCreated
        public void handleCreatedEvent(ClientCacheEntryCreatedEvent<?> e) {
            this.createEvents.add(e);
        }
    }
}

