/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.io.IOException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.marshall.IdentityMarshaller;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

@Test(groups={"functional"}, testName="client.hotrod.MarshallerPerCacheTest")
public class MarshallerPerCacheTest
extends SingleHotRodServerTest {
    private static final String CACHE_TEXT = "text";
    private static final String CACHE_JAVA_SERIALIZED = "serialized";
    private static final String CACHE_DEFAULT = "default";
    private static final Object KEY = 1;
    private static final Object VALUE = "this is the value";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().nonClusteredDefault();
        ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)gcb, (org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        Configuration protobufConfig = new org.infinispan.configuration.cache.ConfigurationBuilder().encoding().mediaType("application/x-protostream").build();
        Configuration defaultConfig = new org.infinispan.configuration.cache.ConfigurationBuilder().build();
        cm.createCache(CACHE_TEXT, defaultConfig);
        cm.createCache(CACHE_JAVA_SERIALIZED, defaultConfig);
        cm.createCache(CACHE_DEFAULT, protobufConfig);
        return cm;
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder builder = super.createHotRodClientConfigurationBuilder(host, serverPort);
        builder.remoteCache(CACHE_TEXT).marshaller(UTF8StringMarshaller.class);
        builder.remoteCache(CACHE_JAVA_SERIALIZED).marshaller(JavaSerializationMarshaller.class);
        return builder;
    }

    @Test
    public void testMarshallerPerCache() throws IOException, InterruptedException {
        this.assertMarshallerUsed(CACHE_DEFAULT, (Marshaller)new ProtoStreamMarshaller());
        this.assertMarshallerUsed(CACHE_TEXT, (Marshaller)new UTF8StringMarshaller());
        this.assertMarshallerUsed(CACHE_JAVA_SERIALIZED, (Marshaller)new JavaSerializationMarshaller());
    }

    @Test
    public void testOverrideMarshallerAtRuntime() throws Exception {
        RemoteCache cache = this.remoteCacheManager.getCache(CACHE_JAVA_SERIALIZED);
        cache.put((Object)"KEY", (Object)"VALUE");
        RemoteCache rawValueCache = cache.withDataFormat(DataFormat.builder().valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build());
        byte[] rawValue = (byte[])rawValueCache.get((Object)"KEY");
        ArrayAsserts.assertArrayEquals((byte[])new JavaSerializationMarshaller().objectToByteBuffer((Object)"VALUE"), (byte[])rawValue);
    }

    private void assertMarshallerUsed(String cacheName, Marshaller expectedMarshaller) throws InterruptedException, IOException {
        RemoteCache remoteCache = this.remoteCacheManager.getCache(cacheName);
        remoteCache.put(KEY, VALUE);
        AssertJUnit.assertEquals((Object)VALUE, (Object)remoteCache.get(KEY));
        Cache cache = this.cacheManager.getCache(remoteCache.getName());
        AdvancedCache asStored = cache.getAdvancedCache().withStorageMediaType();
        byte[] keyMarshalled = expectedMarshaller.objectToByteBuffer(KEY);
        byte[] valueMarshalled = expectedMarshaller.objectToByteBuffer(VALUE);
        ArrayAsserts.assertArrayEquals((byte[])valueMarshalled, (byte[])((byte[])asStored.get((Object)keyMarshalled)));
    }
}

