/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.Collections;
import java.util.Date;
import java.util.concurrent.CompletionStage;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AccountPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.Indexer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.MultipleIndexedCacheTest", groups={"functional"})
public class MultipleIndexedCacheTest
extends MultiHotRodServersTest {
    private static final String USER_CACHE = "users";
    private static final String ACCOUNT_CACHE = "accounts";
    private static final int NODES = 3;
    private static final int NUM_ENTRIES = 50;
    private RemoteCache<Integer, UserPB> userCache;
    private RemoteCache<Integer, AccountPB> accountCache;

    public Configuration buildIndexedConfig() {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)MultipleIndexedCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("sample_bank_account.User").addIndexedEntity("sample_bank_account.Account");
        return builder.build();
    }

    public Configuration getNonIndexLockConfig() {
        return MultipleIndexedCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false).build();
    }

    public Configuration getNonIndexDataConfig() {
        return MultipleIndexedCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false).build();
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        this.createHotRodServers(3, defaultConfiguration);
        this.cacheManagers.forEach(cm -> {
            cm.defineConfiguration(USER_CACHE, this.buildIndexedConfig());
            cm.defineConfiguration(ACCOUNT_CACHE, this.buildIndexedConfig());
            cm.getCache(USER_CACHE);
            cm.getCache(ACCOUNT_CACHE);
        });
        this.waitForClusterToForm(new String[]{USER_CACHE, ACCOUNT_CACHE});
        this.userCache = this.client(0).getCache(USER_CACHE);
        this.accountCache = this.client(0).getCache(ACCOUNT_CACHE);
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDomainSCI.INSTANCE;
    }

    @Test
    public void testMassIndexing() {
        for (int i = 0; i < 50; ++i) {
            AccountPB account = new AccountPB();
            account.setId(i);
            account.setDescription("account" + i);
            account.setCreationDate(new Date());
            this.accountCache.put((Object)account.getId(), (Object)account);
            UserPB user = new UserPB();
            user.setId(i);
            user.setName("name" + i);
            user.setSurname("surname" + i);
            user.setAccountIds(Collections.singleton(i));
            this.userCache.put((Object)user.getId(), (Object)user);
        }
        Assert.assertEquals((long)this.query("sample_bank_account.Account", this.accountCache, "description", "'account1'"), (long)1L);
        Assert.assertEquals((long)this.query("sample_bank_account.User", this.userCache, "name", "'name1'"), (long)1L);
        this.reindex(ACCOUNT_CACHE);
        Assert.assertEquals((long)this.query("sample_bank_account.Account", this.accountCache, "description", "'account1'"), (long)1L);
        Assert.assertEquals((long)this.query("sample_bank_account.User", this.userCache, "name", "'name1'"), (long)1L);
        this.reindex(USER_CACHE);
        Assert.assertEquals((long)this.query("sample_bank_account.Account", this.accountCache, "description", "'account1'"), (long)1L);
        Assert.assertEquals((long)this.query("sample_bank_account.User", this.userCache, "name", "'name1'"), (long)1L);
    }

    private void reindex(String cacheName) {
        Cache cache = ((EmbeddedCacheManager)this.cacheManagers.get(0)).getCache(cacheName);
        Indexer indexer = org.infinispan.query.Search.getIndexer((Cache)cache);
        CompletionStages.join((CompletionStage)indexer.run());
    }

    private <T> long query(String entity, RemoteCache<?, ?> cache, String fieldName, String fieldValue) {
        QueryFactory qf = Search.getQueryFactory(cache);
        Query q = qf.create("FROM " + entity + " WHERE " + fieldName + " = " + fieldValue);
        return q.execute().hitCount().orElse(-1L);
    }
}

