/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.stats.Stats;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.HotRodNonOwnerStatisticsTest")
public class HotRodNonOwnerStatisticsTest
extends MultipleCacheManagersTest {
    private HotRodServer hotRodServer;
    private RemoteCacheManager remoteCacheManager;
    private RemoteCache<Object, Object> remoteCache;

    protected void createCacheManagers() throws Throwable {
        this.newCacheManager();
        this.newCacheManager();
        this.newCacheManager();
        this.hotRodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)((EmbeddedCacheManager)this.cacheManagers.get(0)));
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder(this.hotRodServer);
        clientBuilder.statistics().enable();
        clientBuilder.clientIntelligence(ClientIntelligence.BASIC);
        this.remoteCacheManager = new InternalRemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        this.remoteCacheManager.stop();
        this.hotRodServer.stop();
        super.destroy();
    }

    private void newCacheManager() {
        org.infinispan.configuration.cache.ConfigurationBuilder cfg = HotRodTestingUtil.hotRodCacheConfiguration();
        cfg.statistics().enable();
        cfg.clustering().cacheMode(CacheMode.DIST_SYNC).hash().numOwners(2);
        GlobalConfigurationBuilder globalCfg = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalCfg.jmx().mBeanServerLookup(TestMBeanServerLookup.create()).enable();
        this.addClusterEnabledCacheManager(globalCfg, cfg);
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        super.clearContent();
        Stats cacheStats = this.advancedCache(0).getStats();
        cacheStats.reset();
        this.remoteCache.clientStatistics().resetStatistics();
        this.log.debugf("Stats reset on %s", (Object)this.address(0));
    }

    public void testNonPrimaryGetStats() {
        int keyCount = 10;
        for (int i = 0; i < keyCount; ++i) {
            this.remoteCache.put((Object)("k" + i), (Object)("v" + i));
            this.remoteCache.get((Object)("k" + i));
            this.remoteCache.get((Object)("not_presented" + i));
        }
        AssertJUnit.assertEquals((int)keyCount, (int)this.remoteCache.serverStatistics().getIntStatistic("hits"));
        AssertJUnit.assertEquals((int)keyCount, (int)this.remoteCache.serverStatistics().getIntStatistic("misses"));
    }
}

