/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Map;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.HotRodStatisticsTest")
public class HotRodStatisticsTest
extends AbstractInfinispanTest {
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();
    private HotRodServer hotrodServer;
    private CacheContainer cacheContainer;
    private RemoteCacheManager rcm;
    private RemoteCache<String, String> remoteCache;
    private long startTime;

    @BeforeMethod
    protected void setup() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder cfg = HotRodTestingUtil.hotRodCacheConfiguration();
        cfg.statistics().enable();
        GlobalConfigurationBuilder globalCfg = GlobalConfigurationBuilder.defaultClusteredBuilder();
        TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)globalCfg, (String)((Object)((Object)this)).getClass().getSimpleName(), (MBeanServerLookup)this.mBeanServerLookup);
        this.cacheContainer = TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalCfg, (org.infinispan.configuration.cache.ConfigurationBuilder)cfg);
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheContainer);
        this.startTime = System.currentTimeMillis();
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        clientBuilder.statistics().enable();
        this.rcm = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.rcm.getCache();
    }

    @AfterMethod
    void tearDown() {
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cacheContainer});
        HotRodClientTestingUtil.killRemoteCacheManager(this.rcm);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        this.hotrodServer = null;
    }

    public void testAllStatsArePresent() {
        ServerStatistics serverStatistics = this.remoteCache.serverStatistics();
        Map statsMap = serverStatistics.getStatsMap();
        AssertJUnit.assertEquals((String)((String)statsMap.get("stores")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("currentNumberOfEntries")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("hits")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("misses")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("removeHits")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("removeMisses")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("retrievals")), (String)"0");
        AssertJUnit.assertEquals((String)((String)statsMap.get("totalNumberOfEntries")), (String)"0");
        AssertJUnit.assertEquals((int)0, (int)this.remoteCache.size());
        AssertJUnit.assertTrue((boolean)this.remoteCache.isEmpty());
        Integer number = serverStatistics.getIntStatistic("timeSinceStart");
        AssertJUnit.assertTrue((number >= 0 ? 1 : 0) != 0);
    }

    public void testStoresAndEntries() {
        AssertJUnit.assertEquals((int)0, (int)this.remoteCache.size());
        AssertJUnit.assertTrue((boolean)this.remoteCache.isEmpty());
        this.remoteCache.put((Object)"a", (Object)"v");
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.serverStatistics().getIntStatistic("stores"));
        AssertJUnit.assertEquals((long)1L, (long)this.remoteCache.clientStatistics().getRemoteStores());
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.serverStatistics().getIntStatistic("currentNumberOfEntries"));
        AssertJUnit.assertEquals((int)1, (int)this.remoteCache.size());
        AssertJUnit.assertFalse((boolean)this.remoteCache.isEmpty());
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.serverStatistics().getIntStatistic("totalNumberOfEntries"));
        this.remoteCache.put((Object)"a2", (Object)"v2");
        AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.serverStatistics().getIntStatistic("stores"));
        AssertJUnit.assertEquals((long)2L, (long)this.remoteCache.clientStatistics().getRemoteStores());
        AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.serverStatistics().getIntStatistic("currentNumberOfEntries"));
        AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.serverStatistics().getIntStatistic("totalNumberOfEntries"));
        AssertJUnit.assertEquals((int)2, (int)this.remoteCache.size());
        AssertJUnit.assertFalse((boolean)this.remoteCache.isEmpty());
        this.remoteCache.put((Object)"a2", (Object)"v3");
        AssertJUnit.assertEquals((Object)3, (Object)this.remoteCache.serverStatistics().getIntStatistic("stores"));
        AssertJUnit.assertEquals((long)3L, (long)this.remoteCache.clientStatistics().getRemoteStores());
        AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.serverStatistics().getIntStatistic("currentNumberOfEntries"));
        AssertJUnit.assertEquals((Object)3, (Object)this.remoteCache.serverStatistics().getIntStatistic("totalNumberOfEntries"));
        AssertJUnit.assertEquals((int)2, (int)this.remoteCache.size());
        AssertJUnit.assertFalse((boolean)this.remoteCache.isEmpty());
    }

    public void testHitsAndMisses() {
        this.remoteCache.get((Object)"a");
        AssertJUnit.assertEquals((Object)0, (Object)this.remoteCache.serverStatistics().getIntStatistic("hits"));
        AssertJUnit.assertEquals((long)0L, (long)this.remoteCache.clientStatistics().getRemoteHits());
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.serverStatistics().getIntStatistic("misses"));
        AssertJUnit.assertEquals((long)1L, (long)this.remoteCache.clientStatistics().getRemoteMisses());
        this.remoteCache.put((Object)"a", (Object)"v");
        AssertJUnit.assertEquals((Object)0, (Object)this.remoteCache.serverStatistics().getIntStatistic("hits"));
        AssertJUnit.assertEquals((long)0L, (long)this.remoteCache.clientStatistics().getRemoteHits());
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.serverStatistics().getIntStatistic("misses"));
        AssertJUnit.assertEquals((long)1L, (long)this.remoteCache.clientStatistics().getRemoteMisses());
        this.remoteCache.get((Object)"a");
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.serverStatistics().getIntStatistic("hits"));
        AssertJUnit.assertEquals((long)1L, (long)this.remoteCache.clientStatistics().getRemoteHits());
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.serverStatistics().getIntStatistic("misses"));
        AssertJUnit.assertEquals((long)1L, (long)this.remoteCache.clientStatistics().getRemoteMisses());
        this.remoteCache.get((Object)"a");
        this.remoteCache.get((Object)"a");
        this.remoteCache.get((Object)"a");
        AssertJUnit.assertEquals((Object)4, (Object)this.remoteCache.serverStatistics().getIntStatistic("hits"));
        AssertJUnit.assertEquals((long)4L, (long)this.remoteCache.clientStatistics().getRemoteHits());
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.serverStatistics().getIntStatistic("misses"));
        AssertJUnit.assertEquals((long)1L, (long)this.remoteCache.clientStatistics().getRemoteMisses());
    }

    public void testRemoveHitsAndMisses() {
        this.remoteCache.remove((Object)"a");
        AssertJUnit.assertEquals((Object)0, (Object)this.remoteCache.serverStatistics().getIntStatistic("removeHits"));
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.serverStatistics().getIntStatistic("removeMisses"));
        this.remoteCache.put((Object)"a", (Object)"v");
        this.remoteCache.remove((Object)"a");
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.serverStatistics().getIntStatistic("removeHits"));
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.serverStatistics().getIntStatistic("removeMisses"));
        this.remoteCache.put((Object)"a", (Object)"v");
        this.remoteCache.put((Object)"b", (Object)"v");
        this.remoteCache.put((Object)"c", (Object)"v");
        this.remoteCache.remove((Object)"a");
        this.remoteCache.remove((Object)"b");
        this.remoteCache.remove((Object)"c");
        AssertJUnit.assertEquals((Object)4, (Object)this.remoteCache.serverStatistics().getIntStatistic("removeHits"));
        AssertJUnit.assertEquals((Object)1, (Object)this.remoteCache.serverStatistics().getIntStatistic("removeMisses"));
    }

    public void testNumberOfEntriesAfterClear() {
        AssertJUnit.assertEquals((Object)0, (Object)this.remoteCache.serverStatistics().getIntStatistic("currentNumberOfEntries"));
        this.remoteCache.put((Object)"k", (Object)"v");
        this.remoteCache.put((Object)"k2", (Object)"v");
        AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.serverStatistics().getIntStatistic("currentNumberOfEntries"));
        this.remoteCache.clear();
        AssertJUnit.assertEquals((Object)0, (Object)this.remoteCache.serverStatistics().getIntStatistic("currentNumberOfEntries"));
        AssertJUnit.assertEquals((Object)2, (Object)this.remoteCache.serverStatistics().getIntStatistic("totalNumberOfEntries"));
    }
}

