/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.IOException;
import java.util.Collections;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ProtobufJsonScriptTest")
public class JsonScriptTest
extends MultiHotRodServersTest {
    private static final String SCRIPT_NAME = "json-script.js";
    private static final int CLUSTER_SIZE = 2;

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cfgBuilder = HotRodTestingUtil.hotRodCacheConfiguration((MediaType)MediaType.APPLICATION_JSON);
        this.createHotRodServers(2, cfgBuilder);
        this.waitForClusterToForm();
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        return super.createHotRodClientConfigurationBuilder(host, serverPort).marshaller((Marshaller)new UTF8StringMarshaller());
    }

    @Test
    public void testJSONScript() throws IOException {
        RemoteCacheManager remoteCacheManager = this.client(0);
        this.registerScript(remoteCacheManager, SCRIPT_NAME);
        RemoteCache cache = remoteCacheManager.getCache().withDataFormat(DataFormat.builder().valueType(MediaType.APPLICATION_JSON).build());
        String result = (String)cache.execute(SCRIPT_NAME, Collections.emptyMap());
        Assert.assertEquals((String)result, (String)"{\"v\":\"value2\"}");
    }

    private void registerScript(RemoteCacheManager remoteCacheManager, String script) throws IOException {
        RemoteCache scriptCache = remoteCacheManager.getCache("___script_cache");
        String string = Util.getResourceAsString((String)("/" + script), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        scriptCache.put((Object)SCRIPT_NAME, (Object)string);
    }
}

