/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.client.hotrod.RemoteCache;

public class WorkerThread {
    private static final AtomicInteger WORKER_INDEX = new AtomicInteger();
    private final RemoteCache remoteCache;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, String.format("%s-Worker-%d", Thread.currentThread().getName(), WORKER_INDEX.getAndIncrement())));

    public WorkerThread(RemoteCache remoteCache) {
        this.remoteCache = remoteCache;
    }

    private void stressInternal(AtomicLong opCounter) throws Exception {
        Random rnd = new Random();
        while (!this.executor.isShutdown()) {
            this.remoteCache.put((Object)rnd.nextLong(), (Object)rnd.nextLong());
            opCounter.incrementAndGet();
            Thread.sleep(50L);
        }
    }

    public String put(final String key, final String value) {
        Future<Object> result = this.executor.submit(new Callable<Object>(){

            @Override
            public Object call() {
                return WorkerThread.this.remoteCache.put((Object)key, (Object)value);
            }
        });
        try {
            return (String)result.get();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Error during put", e.getCause());
        }
    }

    public Future<?> putAsync(String key, String value) throws ExecutionException, InterruptedException {
        return this.executor.submit(() -> this.remoteCache.put((Object)key, (Object)value));
    }

    public Future<?> stress(AtomicLong opCounter) throws InterruptedException, ExecutionException {
        return this.executor.submit(() -> {
            this.stressInternal(opCounter);
            return null;
        });
    }

    public void stop() {
        this.executor.shutdown();
    }

    public void awaitTermination() throws InterruptedException, ExecutionException {
        this.executor.awaitTermination(1L, TimeUnit.SECONDS);
    }
}

