/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.counter;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.RemoteCounterManagerFactory;
import org.infinispan.client.hotrod.counter.AbstractCounterTest;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.counter.CounterManagerTestStrategy;
import org.infinispan.server.hotrod.counter.impl.CounterManagerImplTestStrategy;
import org.infinispan.util.logging.Log;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.counter.RemoteCounterManagerTest")
public class RemoteCounterManagerTest
extends AbstractCounterTest
implements CounterManagerTestStrategy {
    private static final String PERSISTENT_LOCATION = CommonsTestingUtil.tmpDirectory((String[])new String[]{"RemoteCounterManagerTest"});
    private static final String TMP_LOCATION = Paths.get(PERSISTENT_LOCATION, "tmp").toString();
    private static final String SHARED_LOCATION = Paths.get(PERSISTENT_LOCATION, "shared").toString();
    private final CounterManagerTestStrategy strategy = new CounterManagerImplTestStrategy(this::allTestCounterManagers, this::log, this::cacheManager);

    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() throws Throwable {
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
        if (!new File(PERSISTENT_LOCATION).mkdirs()) {
            this.log.warnf("Unable to create persistent location file: '%s'", (Object)PERSISTENT_LOCATION);
        }
        super.createBeforeClass();
    }

    public void testWeakCounter(Method method) {
        this.strategy.testWeakCounter(method);
    }

    public void testUnboundedStrongCounter(Method method) {
        this.strategy.testUnboundedStrongCounter(method);
    }

    public void testUpperBoundedStrongCounter(Method method) {
        this.strategy.testUpperBoundedStrongCounter(method);
    }

    public void testLowerBoundedStrongCounter(Method method) {
        this.strategy.testLowerBoundedStrongCounter(method);
    }

    public void testBoundedStrongCounter(Method method) {
        this.strategy.testBoundedStrongCounter(method);
    }

    public void testUndefinedCounter() {
        this.strategy.testUndefinedCounter();
    }

    public void testRemove(Method method) {
        this.strategy.testRemove(method);
    }

    public void testGetCounterNames(Method method) {
        this.strategy.testGetCounterNames(method);
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        super.destroy();
        Util.recursiveFileRemove((String)PERSISTENT_LOCATION);
    }

    @Override
    protected void modifyGlobalConfiguration(GlobalConfigurationBuilder builder) {
        char id = 'A';
        id = (char)(id + this.cacheManagers.size());
        builder.globalState().enable().persistentLocation(Paths.get(PERSISTENT_LOCATION, Character.toString(id)).toString()).temporaryLocation(TMP_LOCATION).sharedPersistentLocation(SHARED_LOCATION);
    }

    private Log log() {
        return this.log;
    }

    private List<CounterManager> allTestCounterManagers() {
        return this.clients.stream().map(RemoteCounterManagerFactory::asCounterManager).collect(Collectors.toList());
    }

    private EmbeddedCacheManager cacheManager() {
        return this.manager(0);
    }
}

