/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.query.dsl.embedded.testdomain.Account;
import org.infinispan.query.dsl.embedded.testdomain.Limits;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.AccountHS;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.LimitsHS;

public class EmbeddedAccountMarshaller
implements MessageMarshaller<AccountHS> {
    public String getTypeName() {
        return "sample_bank_account.Account";
    }

    public Class<AccountHS> getJavaClass() {
        return AccountHS.class;
    }

    public AccountHS readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        int id = reader.readInt("id");
        String description = reader.readString("description");
        long creationDate = reader.readLong("creationDate");
        Limits limits = (Limits)reader.readObject("limits", LimitsHS.class);
        Limits hardLimits = (Limits)reader.readObject("hardLimits", LimitsHS.class);
        List blurb = (List)reader.readCollection("blurb", new ArrayList(), byte[].class);
        Account.Currency[] currencies = (Account.Currency[])reader.readArray("currencies", Account.Currency.class);
        AccountHS account = new AccountHS();
        account.setId(id);
        account.setDescription(description);
        account.setCreationDate(new Date(creationDate));
        account.setLimits(limits);
        account.setHardLimits(hardLimits);
        account.setBlurb(blurb);
        account.setCurrencies(currencies);
        return account;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, AccountHS account) throws IOException {
        writer.writeInt("id", account.getId());
        writer.writeString("description", account.getDescription());
        writer.writeLong("creationDate", account.getCreationDate().getTime());
        writer.writeObject("limits", (Object)account.getLimits(), LimitsHS.class);
        writer.writeObject("hardLimits", (Object)account.getHardLimits(), LimitsHS.class);
        writer.writeCollection("blurb", (Collection)account.getBlurb(), byte[].class);
        writer.writeArray("currencies", (Object[])account.getCurrencies(), Account.Currency.class);
    }
}

