/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.near.MockNearCacheService;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.testng.AssertJUnit;

class AssertsNearCache<K, V> {
    final InternalRemoteCache<K, V> remote;
    final Cache<byte[], ?> server;
    final BlockingQueue<MockNearCacheService.MockEvent> events;
    final RemoteCacheManager manager;
    final NearCacheMode nearCacheMode;
    final AtomicReference<NearCacheService<K, V>> nearCacheService;

    private AssertsNearCache(RemoteCacheManager manager, Cache<byte[], ?> server, BlockingQueue<MockNearCacheService.MockEvent> events, AtomicReference<NearCacheService<K, V>> nearCacheService) {
        this.manager = manager;
        this.remote = (InternalRemoteCache)manager.getCache();
        this.server = server;
        this.events = events;
        this.nearCacheMode = manager.getConfiguration().nearCache().mode();
        this.nearCacheService = nearCacheService;
    }

    static <K, V> AssertsNearCache<K, V> create(Cache<byte[], ?> server, ConfigurationBuilder builder) {
        final ArrayBlockingQueue<MockNearCacheService.MockEvent> events = new ArrayBlockingQueue<MockNearCacheService.MockEvent>(128);
        final AtomicReference<NearCacheService<K, V>> nearCacheServiceRef = new AtomicReference<NearCacheService<K, V>>();
        RemoteCacheManager manager = new RemoteCacheManager(builder.build()){

            protected <KK, VV> NearCacheService<KK, VV> createNearCacheService(String cacheName, NearCacheConfiguration cfg) {
                MockNearCacheService nearCacheService = new MockNearCacheService(cfg, events, this.listenerNotifier);
                nearCacheServiceRef.set(nearCacheService);
                return nearCacheService;
            }
        };
        return new AssertsNearCache<K, V>(manager, server, events, nearCacheServiceRef);
    }

    AssertsNearCache<K, V> get(K key, V expected) {
        AssertJUnit.assertEquals(expected, (Object)this.remote.get(key));
        return this;
    }

    AssertsNearCache<K, V> getAsync(K key, V expected) throws ExecutionException, InterruptedException {
        AssertJUnit.assertEquals(expected, this.remote.getAsync(key).get());
        return this;
    }

    AssertsNearCache<K, V> getWithMetadata(K key, V expected) {
        MetadataValue entry = this.remote.getWithMetadata(key);
        AssertJUnit.assertEquals(expected, (Object)(entry == null ? null : entry.getValue()));
        return this;
    }

    AssertsNearCache<K, V> getWithMetadataAsync(K key, V expected) throws ExecutionException, InterruptedException {
        MetadataValue entry = (MetadataValue)this.remote.getWithMetadataAsync(key).get();
        AssertJUnit.assertEquals(expected, (Object)(entry == null ? null : entry.getValue()));
        return this;
    }

    AssertsNearCache<K, V> put(K key, V value) {
        this.remote.put(key, value);
        return this;
    }

    AssertsNearCache<K, V> putAsync(K key, V value) throws ExecutionException, InterruptedException {
        this.remote.putAsync(key, value).get();
        return this;
    }

    AssertsNearCache<K, V> putAsync(K key, V value, long time, TimeUnit timeUnit) throws ExecutionException, InterruptedException {
        this.remote.putAsync(key, value, time, timeUnit).get();
        return this;
    }

    AssertsNearCache<K, V> putAsync(K key, V value, long time, TimeUnit timeUnit, long idle, TimeUnit idleTimeUnit) throws ExecutionException, InterruptedException {
        this.remote.putAsync(key, value, time, timeUnit, idle, idleTimeUnit).get();
        return this;
    }

    AssertsNearCache<K, V> remove(K key) {
        this.remote.remove(key);
        return this;
    }

    AssertsNearCache<K, V> removeAsync(K key) throws ExecutionException, InterruptedException {
        this.remote.removeAsync(key).get();
        return this;
    }

    AssertsNearCache<K, V> expectNoNearEvents() {
        AssertJUnit.assertEquals((String)this.events.toString(), (int)0, (int)this.events.size());
        return this;
    }

    AssertsNearCache<K, V> expectNoNearEvents(long time, TimeUnit timeUnit) throws InterruptedException {
        MockNearCacheService.MockEvent event = this.events.poll(time, timeUnit);
        AssertJUnit.assertNull((String)("Event was: " + event), (Object)event);
        return this;
    }

    AssertsNearCache<K, V> expectNearGetValueVersion(K key, V value) {
        MockNearCacheService.MockGetEvent get = this.assertGetKeyValue(key, value);
        if (value != null) {
            long serverVersion = HotRodClientTestingUtil.entryVersion(this.server.getAdvancedCache().withStorageMediaType(), key);
            AssertJUnit.assertEquals((long)serverVersion, (long)get.value.getVersion());
        }
        return this;
    }

    AssertsNearCache<K, V> expectNearGetValue(K key, V value) {
        this.assertGetKeyValue(key, value);
        return this;
    }

    AssertsNearCache<K, V> expectNearGetNull(K key) {
        MockNearCacheService.MockGetEvent get = this.assertGetKey(key);
        AssertJUnit.assertNull((Object)get.value);
        return this;
    }

    @SafeVarargs
    final AssertsNearCache<K, V> expectNearPut(K key, V value, AssertsNearCache<K, V> ... affected) {
        AssertsNearCache.expectNearPutInClient(this, key, value);
        for (AssertsNearCache<K, V> client : affected) {
            AssertsNearCache.expectNearPutInClient(client, key, value);
        }
        return this;
    }

    private static <K, V> void expectNearPutInClient(AssertsNearCache<K, V> client, K key, V value) {
        MockNearCacheService.MockPutEvent put = (MockNearCacheService.MockPutEvent)AssertsNearCache.pollEvent(client.events);
        AssertJUnit.assertEquals(key, (Object)put.key);
        AssertJUnit.assertEquals(value, (Object)put.value.getValue());
    }

    AssertsNearCache<K, V> expectNearPutIfAbsent(K key, V value) {
        MockNearCacheService.MockPutIfAbsentEvent put = (MockNearCacheService.MockPutIfAbsentEvent)AssertsNearCache.pollEvent(this.events);
        AssertJUnit.assertEquals(key, (Object)put.key);
        AssertJUnit.assertEquals(value, (Object)put.value.getValue());
        return this;
    }

    public AssertsNearCache<K, V> expectNearPreemptiveRemove(K key) {
        MockNearCacheService.MockRemoveEvent preemptiveRemove = (MockNearCacheService.MockRemoveEvent)AssertsNearCache.pollEvent(this.events);
        AssertJUnit.assertEquals(key, preemptiveRemove.key);
        this.expectNoNearEvents();
        return this;
    }

    public AssertsNearCache<K, V> expectNearPreemptiveRemove(K key, AssertsNearCache<K, V> ... affected) {
        MockNearCacheService.MockRemoveEvent preemptiveRemove = (MockNearCacheService.MockRemoveEvent)AssertsNearCache.pollEvent(this.events);
        AssertJUnit.assertEquals(key, preemptiveRemove.key);
        this.expectNoNearEvents();
        for (AssertsNearCache<K, V> client : affected) {
            AssertsNearCache.expectRemoteNearRemoveInClient(client, key);
        }
        return this;
    }

    @SafeVarargs
    final AssertsNearCache<K, V> expectNearRemove(K key, AssertsNearCache<K, V> ... affected) {
        AssertsNearCache.expectLocalNearRemoveInClient(this, key);
        for (AssertsNearCache<K, V> client : affected) {
            AssertsNearCache.expectRemoteNearRemoveInClient(client, key);
        }
        return this;
    }

    @SafeVarargs
    final AssertsNearCache<K, V> expectNearClear(AssertsNearCache<K, V> ... affected) {
        this.expectNearClearInClient(this);
        for (AssertsNearCache<K, V> client : affected) {
            this.expectNearClearInClient(client);
        }
        return this;
    }

    void expectNearClearInClient(AssertsNearCache<K, V> client) {
        Object clear = AssertsNearCache.pollEvent(client.events);
        AssertJUnit.assertTrue((String)("Unexpected event: " + clear), (boolean)(clear instanceof MockNearCacheService.MockClearEvent));
    }

    void resetEvents() {
        this.events.clear();
    }

    void stop() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.manager);
    }

    private static <K, V> void expectLocalNearRemoveInClient(AssertsNearCache<K, V> client, K key) {
        MockNearCacheService.MockRemoveEvent preemptiveRemove = (MockNearCacheService.MockRemoveEvent)AssertsNearCache.pollEvent(client.events);
        AssertJUnit.assertEquals(key, preemptiveRemove.key);
        MockNearCacheService.MockRemoveEvent remoteRemove = (MockNearCacheService.MockRemoveEvent)AssertsNearCache.pollEvent(client.events);
        AssertJUnit.assertEquals(key, remoteRemove.key);
    }

    private static <K, V> void expectRemoteNearRemoveInClient(AssertsNearCache<K, V> client, K key) {
        MockNearCacheService.MockRemoveEvent remoteRemove = (MockNearCacheService.MockRemoveEvent)AssertsNearCache.pollEvent(client.events);
        AssertJUnit.assertEquals(key, remoteRemove.key);
    }

    private static <E extends MockNearCacheService.MockEvent> E pollEvent(BlockingQueue<MockNearCacheService.MockEvent> events) {
        try {
            MockNearCacheService.MockEvent event = events.poll(10L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull((Object)event);
            return (E)event;
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    private MockNearCacheService.MockGetEvent assertGetKey(K key) {
        MockNearCacheService.MockGetEvent get = (MockNearCacheService.MockGetEvent)AssertsNearCache.pollEvent(this.events);
        AssertJUnit.assertEquals(key, (Object)get.key);
        return get;
    }

    private MockNearCacheService.MockGetEvent assertGetKeyValue(K key, V value) {
        MockNearCacheService.MockGetEvent get = this.assertGetKey(key);
        AssertJUnit.assertEquals(value, get.value == null ? null : get.value.getValue());
        return get;
    }

    public int nearCacheSize() {
        return this.nearCacheService.get().size();
    }
}

