/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.near.AssertsNearCache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.near.ClusterInvalidatedNearCacheBloomTest")
public class ClusterInvalidatedNearCacheBloomTest
extends MultiHotRodServersTest {
    private static final int CLUSTER_MEMBERS = 3;
    private static final int NEAR_CACHE_SIZE = 4;
    List<AssertsNearCache<Integer, String>> assertClients = new ArrayList<AssertsNearCache<Integer, String>>(3);
    AssertsNearCache<Integer, String> client0;
    AssertsNearCache<Integer, String> client1;
    AssertsNearCache<Integer, String> client2;

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, this.getCacheConfiguration());
        this.client0 = this.assertClients.get(0);
        this.client1 = this.assertClients.get(1);
        this.client2 = this.assertClients.get(2);
    }

    @BeforeMethod
    void beforeMethod() {
        this.assertClients.forEach(AssertsNearCache::expectNoNearEvents);
        this.assertClients.forEach(ac -> CompletionStages.join((CompletionStage)ac.remote.updateBloomFilter()));
    }

    @AfterMethod
    void afterMethod() {
        this.caches().forEach(Cache::clear);
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        for (AssertsNearCache<Integer, String> assertsNearCache : this.assertClients) {
            try {
                assertsNearCache.expectNoNearEvents(50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.assertClients.forEach(AssertsNearCache::stop);
        this.assertClients.clear();
        super.destroy();
    }

    private org.infinispan.configuration.cache.ConfigurationBuilder getCacheConfiguration() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = ClusterInvalidatedNearCacheBloomTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numOwners(1);
        return HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
    }

    @Override
    protected RemoteCacheManager createClient(int i) {
        AssertsNearCache asserts = this.createAssertClient();
        this.assertClients.add(asserts);
        return asserts.manager;
    }

    private <K, V> AssertsNearCache<K, V> createAssertClient() {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        for (HotRodServer server : this.servers) {
            clientBuilder.addServer().host("127.0.0.1").port(server.getPort().intValue());
        }
        clientBuilder.connectionPool().maxActive(1);
        clientBuilder.nearCache().mode(NearCacheMode.INVALIDATED).maxEntries(4).bloomFilter(true);
        return AssertsNearCache.create(this.cache(0), clientBuilder);
    }

    public void testInvalidationFromOtherClientModification() {
        int key = 0;
        this.client1.get(key, null).expectNearGetNull(key);
        this.client2.get(key, null).expectNearGetNull(key);
        String value = "v1";
        this.client1.put(key, value).expectNearPreemptiveRemove(key);
        this.client2.expectNoNearEvents();
        this.client2.get(key, value).expectNearGetNull(key).expectNearPutIfAbsent(key, value);
        this.client2.get(key, value).expectNearGetValue(key, value);
        this.client1.remove(key).expectNearPreemptiveRemove(key, this.client2);
    }

    public void testClientsBothCachedAndCanUpdate() {
        int key = 0;
        String value = "v1";
        this.client1.put(key, value).expectNearPreemptiveRemove(key);
        this.client1.get(key, value).expectNearGetNull(key).expectNearPutIfAbsent(key, value);
        this.client2.get(key, value).expectNearGetNull(key).expectNearPutIfAbsent(key, value);
        String value2 = "v2";
        this.client1.put(key, value2).expectNearRemove(key, this.client2);
        this.client2.put(key, value).expectNearRemove(key, this.client1);
        CompletionStages.join((CompletionStage)this.client1.remote.updateBloomFilter());
        CompletionStages.join((CompletionStage)this.client2.remote.updateBloomFilter());
        this.client2.put(key, value).expectNearPreemptiveRemove(key);
        this.client1.put(key, value).expectNearPreemptiveRemove(key);
    }
}

