/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.query.RemoteQueryTestUtils;
import org.infinispan.client.hotrod.query.testdomain.protobuf.TestEntity;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.BuiltInAnalyzersTest")
public class BuiltInAnalyzersTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("TestEntity");
        EmbeddedCacheManager manager = TestCacheManagerFactory.createServerModeCacheManager();
        Cache metadataCache = manager.getCache("___protobuf_metadata");
        String protoFile = Util.getResourceAsString((String)"/analyzers.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        metadataCache.put((Object)"analyzers.proto", (Object)protoFile);
        RemoteQueryTestUtils.checkSchemaErrors((BasicCache<String, String>)metadataCache);
        manager.defineConfiguration("test", builder.build());
        return manager;
    }

    @BeforeClass
    protected void registerProtobufSchema() throws Exception {
        String protoFile = Util.getResourceAsString((String)"/analyzers.proto", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        SerializationContext serCtx = MarshallerUtil.getSerializationContext((RemoteCacheManager)this.remoteCacheManager);
        serCtx.registerProtoFiles(FileDescriptorSource.fromString((String)"analyzers.proto", (String)protoFile));
        serCtx.registerMarshaller((BaseMarshaller)new TestEntity.TestEntityMarshaller());
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        return new InternalRemoteCacheManager(builder.build());
    }

    @Test
    public void testKeywordAnalyzer() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache("test");
        TestEntity child = new TestEntity("name", "name", "name", "name-with-dashes", "name", "name", null);
        TestEntity parent = new TestEntity("name", "name", "name", "name-with-dashes", "name", "name", child);
        remoteCache.put((Object)1, (Object)parent);
        QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)remoteCache);
        AssertJUnit.assertEquals((long)1L, (long)queryFactory.create("From TestEntity where name4:'name-with-dashes'").execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)1L, (long)queryFactory.create("From TestEntity p where p.child.name4:'name-with-dashes'").execute().hitCount().orElse(-1L));
    }

    @Test
    public void testShippedAnalyzers() {
        RemoteCache remoteCache = this.remoteCacheManager.getCache("test");
        TestEntity testEntity = new TestEntity("Sarah-Jane Lee", "John McDougall", "James Connor", "Oswald Lee", "Jason Hawkings", "Gyorgy Constantinides");
        remoteCache.put((Object)1, (Object)testEntity);
        QueryFactory queryFactory = Search.getQueryFactory((RemoteCache)remoteCache);
        AssertJUnit.assertEquals((long)1L, (long)queryFactory.create("From TestEntity where name1:'jane'").execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)1L, (long)queryFactory.create("From TestEntity where name2:'McDougall'").execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)1L, (long)queryFactory.create("From TestEntity where name3:'Connor'").execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)1L, (long)queryFactory.create("From TestEntity where name4:'Oswald Lee'").execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)1L, (long)queryFactory.create("From TestEntity where name5:'hawk'").execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)1L, (long)queryFactory.create("From TestEntity where name6:'constan'").execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)0L, (long)queryFactory.create("From TestEntity where name1:'sara'").execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)0L, (long)queryFactory.create("From TestEntity where name2:'John McDougal'").execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)0L, (long)queryFactory.create("From TestEntity where name3:'James-Connor'").execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)0L, (long)queryFactory.create("From TestEntity where name4:'Oswald lee'").execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)0L, (long)queryFactory.create("From TestEntity where name5:'json'").execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)0L, (long)queryFactory.create("From TestEntity where name6:'Georje'").execute().hitCount().orElse(-1L));
    }
}

