/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.RemoteQueryNonQueryableCacheTest", groups={"functional"})
public class RemoteQueryNonQueryableCacheTest
extends SingleHotRodServerTest {
    private static final String DEFAULT_CACHE = "default";
    private static final String INDEXED_CACHE = "indexed";
    private static final String PROTOBUF_CACHE = "protobuf";
    private static final String POJO_CACHE = "object";
    private static final String JSON_CACHE = "json";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createServerModeCacheManager((SerializationContextInitializer)TestDomainSCI.INSTANCE, (ConfigurationBuilder)new ConfigurationBuilder());
        cm.defineConfiguration(DEFAULT_CACHE, new ConfigurationBuilder().build());
        cm.defineConfiguration(INDEXED_CACHE, this.createIndexedCache());
        cm.defineConfiguration(PROTOBUF_CACHE, this.createCache("application/x-protostream"));
        cm.defineConfiguration(POJO_CACHE, this.createCache("application/x-java-object"));
        cm.defineConfiguration(JSON_CACHE, this.createCache("application/json"));
        return cm;
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDataSCI.INSTANCE;
    }

    private Configuration createCache(String mediaType) {
        return new ConfigurationBuilder().encoding().mediaType(mediaType).build();
    }

    private Configuration createIndexedCache() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("sample_bank_account.User").addIndexedEntity("sample_bank_account.Account").addIndexedEntity("sample_bank_account.Transaction");
        return builder.build();
    }

    @Test
    public void testQueryable() {
        this.executeQuery(DEFAULT_CACHE);
        this.executeQuery(INDEXED_CACHE);
        this.executeQuery(PROTOBUF_CACHE);
        this.executeQuery(POJO_CACHE);
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN028015.*")
    public void assertErrorForCacheWithoutNonQueryableEncoding() {
        this.executeQuery(JSON_CACHE);
    }

    private void executeQuery(String cacheName) {
        RemoteCache remoteCache = this.remoteCacheManager.getCache(cacheName);
        Query q = Search.getQueryFactory((RemoteCache)remoteCache).create("FROM sample_bank_account.User");
        q.execute();
    }
}

