/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tx;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.tx.util.KeyValueGenerator;
import org.infinispan.client.hotrod.tx.util.TransactionSetup;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.tx.APITxTest")
public class APITxTest<K, V>
extends MultiHotRodServersTest {
    private static final int NR_NODES = 2;
    private static final String CACHE_NAME = "api-tx-cache";
    private KeyValueGenerator<K, V> kvGenerator;
    private TransactionMode transactionMode;
    private boolean useJavaSerialization;

    public Object[] factory() {
        return Arrays.stream(TransactionMode.values()).filter(tMode -> tMode != TransactionMode.NONE).flatMap(txMode -> Arrays.stream(LockingMode.values()).flatMap(lockingMode -> Stream.builder().add(super.transactionMode((TransactionMode)txMode).lockingMode((LockingMode)lockingMode)).add(super.transactionMode((TransactionMode)txMode).lockingMode((LockingMode)lockingMode)).add(super.transactionMode((TransactionMode)txMode).lockingMode((LockingMode)lockingMode)).build())).toArray();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        HotRodClientTestingUtil.assertNoTransaction(this.clients);
        super.clearContent();
    }

    public void testPut(Method method) throws Exception {
        this.doApiTest(method, this::empty, this::put, this::putDataCheck, this::checkNoKeys, 3, 3, true);
    }

    public void testPutAsync(Method method) throws Exception {
        this.doApiTest(method, this::empty, this::put, this::putDataCheck, this::checkNoKeys, 3, 3, false);
    }

    public void testPutIfAbsent(Method method) throws Exception {
        this.doApiTest(method, this::empty, this::putIfAbsent, this::putDataCheck, this::checkNoKeys, 3, 3, true);
    }

    public void testPutIfAbsentAsync(Method method) throws Exception {
        this.doApiTest(method, this::empty, this::putIfAbsent, this::putDataCheck, this::checkNoKeys, 3, 3, false);
    }

    public void testPutAll(Method method) throws Exception {
        this.doApiTest(method, this::empty, this::putAll, this::putAllDataCheck, this::checkNoKeys, 6, 6, true);
    }

    public void testPutAllAsync(Method method) throws Exception {
        this.doApiTest(method, this::empty, this::putAll, this::putAllDataCheck, this::checkNoKeys, 6, 6, false);
    }

    public void testReplace(Method method) throws Exception {
        this.doApiTest(method, this::initKeys, this::replace, this::secondHalfDataCheck, this::checkInitValue, 6, 12, true);
    }

    public void testReplaceAsync(Method method) throws Exception {
        this.doApiTest(method, this::initKeys, this::replace, this::secondHalfDataCheck, this::checkInitValue, 6, 12, false);
    }

    public void testReplaceWithVersion(Method method) throws Exception {
        this.doApiTest(method, this::initKeys, this::replaceWithVersion, this::secondHalfDataCheck, this::checkInitValue, 4, 8, true);
    }

    public void testReplaceWithVersionAsync(Method method) throws Exception {
        this.doApiTest(method, this::initKeys, this::replaceWithVersion, this::secondHalfDataCheck, this::checkInitValue, 4, 8, false);
    }

    public void testRemove(Method method) throws Exception {
        this.doApiTest(method, this::initKeys, this::remove, this::checkNoKeys, this::checkInitValue, 2, 2, true);
    }

    public void testRemoveAsync(Method method) throws Exception {
        this.doApiTest(method, this::initKeys, this::remove, this::checkNoKeys, this::checkInitValue, 2, 2, false);
    }

    public void testRemoveWithVersion(Method method) throws Exception {
        this.doApiTest(method, this::initKeys, this::removeWithVersion, this::checkNoKeys, this::checkInitValue, 1, 1, true);
    }

    public void testRemoveWithVersionAsync(Method method) throws Exception {
        this.doApiTest(method, this::initKeys, this::removeWithVersion, this::checkNoKeys, this::checkInitValue, 1, 1, false);
    }

    public void testMerge(Method method) throws Exception {
        RemoteCache cache = this.txRemoteCache();
        TransactionManager tm = cache.getTransactionManager();
        List keys = this.generateKeys(method, 3);
        List values = this.generateValues(method, 3);
        tm.begin();
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.merge(keys.get(0), values.get(0), (v1, v2) -> values.get(0)));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.merge(keys.get(0), values.get(0), (v1, v2) -> values.get(0), 1L, TimeUnit.MINUTES));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.merge(keys.get(0), values.get(0), (v1, v2) -> values.get(0), 2L, TimeUnit.MINUTES, 3L, TimeUnit.MINUTES));
        tm.commit();
    }

    public void testContainsKeyAndValue(Method method) throws Exception {
        RemoteCache<K, V> cache = this.txRemoteCache();
        TransactionManager tm = cache.getTransactionManager();
        K key = this.kvGenerator.generateKey(method, 0);
        K key1 = this.kvGenerator.generateKey(method, 1);
        V value = this.kvGenerator.generateValue(method, 0);
        V value1 = this.kvGenerator.generateValue(method, 1);
        cache.put(key, value);
        cache.put(key1, value1);
        tm.begin();
        AssertJUnit.assertTrue((boolean)cache.containsKey(key));
        AssertJUnit.assertTrue((boolean)cache.containsValue(value));
        AssertJUnit.assertTrue((boolean)cache.containsKey(key1));
        AssertJUnit.assertTrue((boolean)cache.containsValue(value1));
        cache.remove(key);
        AssertJUnit.assertFalse((boolean)cache.containsKey(key));
        AssertJUnit.assertFalse((boolean)cache.containsValue(value));
        AssertJUnit.assertTrue((boolean)cache.containsKey(key1));
        AssertJUnit.assertTrue((boolean)cache.containsValue(value1));
        Transaction tx = tm.suspend();
        AssertJUnit.assertTrue((boolean)cache.containsKey(key));
        AssertJUnit.assertTrue((boolean)cache.containsValue(value));
        AssertJUnit.assertTrue((boolean)cache.containsKey(key1));
        AssertJUnit.assertTrue((boolean)cache.containsValue(value1));
        tm.resume(tx);
        tm.commit();
        tm.begin();
        AssertJUnit.assertFalse((boolean)cache.containsKey(key));
        AssertJUnit.assertFalse((boolean)cache.containsValue(value));
        AssertJUnit.assertTrue((boolean)cache.containsKey(key1));
        AssertJUnit.assertTrue((boolean)cache.containsValue(value1));
        cache.put(key, value);
        AssertJUnit.assertTrue((boolean)cache.containsKey(key));
        AssertJUnit.assertTrue((boolean)cache.containsValue(value));
        AssertJUnit.assertTrue((boolean)cache.containsKey(key1));
        AssertJUnit.assertTrue((boolean)cache.containsValue(value1));
        Transaction tx2 = tm.suspend();
        AssertJUnit.assertFalse((boolean)cache.containsKey(key));
        AssertJUnit.assertFalse((boolean)cache.containsValue(value));
        AssertJUnit.assertTrue((boolean)cache.containsKey(key1));
        AssertJUnit.assertTrue((boolean)cache.containsValue(value1));
        tm.resume(tx2);
        tm.commit();
        AssertJUnit.assertTrue((boolean)cache.containsKey(key));
        AssertJUnit.assertTrue((boolean)cache.containsValue(value));
        AssertJUnit.assertTrue((boolean)cache.containsKey(key1));
        AssertJUnit.assertTrue((boolean)cache.containsValue(value1));
    }

    public void testComputeIfAbsentMethods(Method method) {
        RemoteCache cache = this.txRemoteCache();
        Object targetKey = this.kvGenerator.generateKey(method, 0);
        Function<Object, Object> remappingFunction = key -> this.kvGenerator.generateValue(method, 1);
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfAbsent(targetKey, remappingFunction));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfAbsent(targetKey, remappingFunction, 1L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfAbsent(targetKey, remappingFunction, 1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfAbsentAsync(targetKey, remappingFunction));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfAbsentAsync(targetKey, remappingFunction, 1L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfAbsentAsync(targetKey, remappingFunction, 1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS));
    }

    public void testComputeIfPresentMethods(Method method) {
        RemoteCache cache = this.txRemoteCache();
        Object targetKey = this.kvGenerator.generateKey(method, 0);
        BiFunction<Object, Object, Object> remappingFunction = (key, value) -> this.kvGenerator.generateValue(method, 1);
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfPresent(targetKey, remappingFunction));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfPresent(targetKey, remappingFunction, 1L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfPresent(targetKey, remappingFunction, 1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfPresentAsync(targetKey, remappingFunction));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfPresentAsync(targetKey, remappingFunction, 1L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.computeIfPresentAsync(targetKey, remappingFunction, 1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS));
    }

    public void testMergeMethods(Method method) {
        RemoteCache cache = this.txRemoteCache();
        Object targetKey = this.kvGenerator.generateKey(method, 0);
        Object targetValue = this.kvGenerator.generateValue(method, 0);
        BiFunction<Object, Object, Object> remappingFunction = (value1, value2) -> this.kvGenerator.generateValue(method, 2);
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.merge(targetKey, targetValue, remappingFunction));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.merge(targetKey, targetValue, remappingFunction, 1L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.merge(targetKey, targetValue, remappingFunction, 1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.mergeAsync(targetKey, targetValue, remappingFunction));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.mergeAsync(targetKey, targetValue, remappingFunction, 1L, TimeUnit.SECONDS));
        Exceptions.expectException(UnsupportedOperationException.class, () -> cache.mergeAsync(targetKey, targetValue, remappingFunction, 1L, TimeUnit.SECONDS, 10L, TimeUnit.SECONDS));
    }

    protected boolean cleanupAfterMethod() {
        try {
            this.cleanupTransactions();
        }
        catch (SystemException e) {
            this.log.error((Object)"Error cleaning up running transactions", (Throwable)e);
        }
        return super.cleanupAfterMethod();
    }

    protected String[] parameterNames() {
        return (String[])APITxTest.concat((Object[])super.parameterNames(), (Object[])new String[]{null, null, null});
    }

    protected Object[] parameterValues() {
        return APITxTest.concat((Object[])super.parameterValues(), (Object[])new Object[]{this.kvGenerator.toString(), this.transactionMode, this.lockingMode});
    }

    protected String parameters() {
        return "[" + this.kvGenerator + "/" + this.transactionMode + "/" + this.lockingMode + "]";
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cacheBuilder = APITxTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        cacheBuilder.transaction().lockingMode(this.lockingMode);
        cacheBuilder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.createHotRodServers(2, new org.infinispan.configuration.cache.ConfigurationBuilder());
        this.defineInAll(CACHE_NAME, cacheBuilder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder clientBuilder = super.createHotRodClientConfigurationBuilder(host, serverPort);
        clientBuilder.forceReturnValues(false);
        TransactionSetup.amendJTA(clientBuilder.remoteCache(CACHE_NAME)).transactionMode(this.transactionMode);
        if (this.useJavaSerialization) {
            clientBuilder.marshaller((Marshaller)new JavaSerializationMarshaller()).addJavaSerialAllowList(new String[]{"\\Q[\\ELjava.lang.Object;"});
        }
        return clientBuilder;
    }

    private void cleanupTransactions() throws SystemException {
        RemoteCache<K, V> cache = this.txRemoteCache();
        TransactionManager tm = cache.getTransactionManager();
        if (tm.getTransaction() != null) {
            tm.rollback();
        }
    }

    private APITxTest<K, V> transactionMode(TransactionMode transactionMode) {
        this.transactionMode = transactionMode;
        return this;
    }

    private APITxTest<K, V> keyValueGenerator(KeyValueGenerator<K, V> kvGenerator) {
        this.kvGenerator = kvGenerator;
        return this;
    }

    public APITxTest<K, V> javaSerialization() {
        this.useJavaSerialization = true;
        return this;
    }

    private void doApiTest(Method method, Step<K, V> init, OperationStep<K, V> op, DataCheck<K, V> dataCheck, Step<K, V> isolationCheck, int keysCount, int valuesCount, boolean sync) throws Exception {
        RemoteCache<K, V> cache = this.txRemoteCache();
        TransactionManager tm = cache.getTransactionManager();
        List<K> keys = this.generateKeys(method, keysCount);
        List<V> values = this.generateValues(method, valuesCount);
        init.execute(keys, values);
        tm.begin();
        op.execute(keys, values, sync);
        dataCheck.execute(keys, values, true);
        Transaction tx = tm.suspend();
        isolationCheck.execute(keys, values);
        tm.resume(tx);
        tm.commit();
        dataCheck.execute(keys, values, false);
    }

    private void empty(List<K> keys, List<V> values) {
    }

    private void initKeys(List<K> keys, List<V> values) {
        RemoteCache<K, V> cache = this.txRemoteCache();
        for (int i = 0; i < keys.size(); ++i) {
            cache.put(keys.get(i), values.get(i));
        }
    }

    private void checkNoKeys(List<K> keys, List<V> values) {
        this.checkNoKeys(keys, values, true);
    }

    private void checkNoKeys(List<K> keys, List<V> values, boolean inTx) {
        RemoteCache<K, V> cache = this.txRemoteCache();
        for (K key : keys) {
            AssertJUnit.assertNull((Object)cache.get(key));
        }
    }

    private void checkInitValue(List<K> keys, List<V> values) {
        RemoteCache<K, V> cache = this.txRemoteCache();
        for (int i = 0; i < keys.size(); ++i) {
            this.kvGenerator.assertValueEquals(values.get(i), cache.get(keys.get(i)));
        }
    }

    private void secondHalfDataCheck(List<K> keys, List<V> values, boolean inTx) {
        this.putDataCheck(keys, values.subList(keys.size(), values.size()), inTx);
    }

    private void put(List<K> keys, List<V> values, boolean sync) throws Exception {
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        AssertJUnit.assertEquals((int)3, (int)values.size());
        RemoteCache<K, V> cache = this.txRemoteCache();
        if (sync) {
            cache.put(keys.get(0), values.get(0));
            cache.put(keys.get(1), values.get(1), 1L, TimeUnit.MINUTES);
            cache.put(keys.get(2), values.get(2), 2L, TimeUnit.MINUTES, 3L, TimeUnit.MINUTES);
        } else {
            cache.putAsync(keys.get(0), values.get(0)).get();
            cache.putAsync(keys.get(1), values.get(1), 1L, TimeUnit.MINUTES).get();
            cache.putAsync(keys.get(2), values.get(2), 2L, TimeUnit.MINUTES, 3L, TimeUnit.MINUTES).get();
        }
    }

    private void putIfAbsent(List<K> keys, List<V> values, boolean sync) throws Exception {
        AssertJUnit.assertEquals((int)3, (int)keys.size());
        AssertJUnit.assertEquals((int)3, (int)values.size());
        RemoteCache<K, V> cache = this.txRemoteCache();
        if (sync) {
            cache.putIfAbsent(keys.get(0), values.get(0));
            cache.putIfAbsent(keys.get(1), values.get(1), 1L, TimeUnit.MINUTES);
            cache.putIfAbsent(keys.get(2), values.get(2), 2L, TimeUnit.MINUTES, 3L, TimeUnit.MINUTES);
        } else {
            cache.putIfAbsentAsync(keys.get(0), values.get(0)).get();
            cache.putIfAbsentAsync(keys.get(1), values.get(1), 1L, TimeUnit.MINUTES).get();
            cache.putIfAbsentAsync(keys.get(2), values.get(2), 2L, TimeUnit.MINUTES, 3L, TimeUnit.MINUTES).get();
        }
    }

    private void putDataCheck(List<K> keys, List<V> values, boolean inTx) {
        RemoteCache<K, V> cache = this.txRemoteCache();
        this.kvGenerator.assertValueEquals(values.get(0), cache.get(keys.get(0)));
        this.assertMetadataValue(values.get(1), cache.getWithMetadata(keys.get(1)), TimeUnit.MINUTES.toSeconds(1L), inTx ? 0L : -1L);
        this.assertMetadataValue(values.get(2), cache.getWithMetadata(keys.get(2)), TimeUnit.MINUTES.toSeconds(2L), TimeUnit.MINUTES.toSeconds(3L));
    }

    private void putAll(List<K> keys, List<V> values, boolean sync) throws Exception {
        AssertJUnit.assertEquals((int)6, (int)keys.size());
        AssertJUnit.assertEquals((int)6, (int)values.size());
        RemoteCache<K, V> cache = this.txRemoteCache();
        if (sync) {
            HashMap<K, V> map = new HashMap<K, V>();
            map.put(keys.get(0), values.get(0));
            map.put(keys.get(1), values.get(1));
            cache.putAll(map);
            map.clear();
            map.put(keys.get(2), values.get(2));
            map.put(keys.get(3), values.get(3));
            cache.putAll(map, 1L, TimeUnit.MINUTES);
            map.clear();
            map.put(keys.get(4), values.get(4));
            map.put(keys.get(5), values.get(5));
            cache.putAll(map, 2L, TimeUnit.MINUTES, 3L, TimeUnit.MINUTES);
        } else {
            HashMap<K, V> map = new HashMap<K, V>();
            map.put(keys.get(0), values.get(0));
            map.put(keys.get(1), values.get(1));
            cache.putAllAsync(map).get();
            map.clear();
            map.put(keys.get(2), values.get(2));
            map.put(keys.get(3), values.get(3));
            cache.putAllAsync(map, 1L, TimeUnit.MINUTES).get();
            map.clear();
            map.put(keys.get(4), values.get(4));
            map.put(keys.get(5), values.get(5));
            cache.putAllAsync(map, 2L, TimeUnit.MINUTES, 3L, TimeUnit.MINUTES).get();
        }
    }

    private void putAllDataCheck(List<K> keys, List<V> values, boolean inTx) {
        RemoteCache<K, V> cache = this.txRemoteCache();
        this.kvGenerator.assertValueEquals(values.get(0), cache.get(keys.get(0)));
        this.kvGenerator.assertValueEquals(values.get(1), cache.get(keys.get(1)));
        this.assertMetadataValue(values.get(2), cache.getWithMetadata(keys.get(2)), TimeUnit.MINUTES.toSeconds(1L), inTx ? 0L : -1L);
        this.assertMetadataValue(values.get(3), cache.getWithMetadata(keys.get(3)), TimeUnit.MINUTES.toSeconds(1L), inTx ? 0L : -1L);
        this.assertMetadataValue(values.get(4), cache.getWithMetadata(keys.get(4)), TimeUnit.MINUTES.toSeconds(2L), TimeUnit.MINUTES.toSeconds(3L));
        this.assertMetadataValue(values.get(5), cache.getWithMetadata(keys.get(5)), TimeUnit.MINUTES.toSeconds(2L), TimeUnit.MINUTES.toSeconds(3L));
    }

    private void replace(List<K> keys, List<V> values, boolean sync) throws Exception {
        AssertJUnit.assertEquals((int)6, (int)keys.size());
        AssertJUnit.assertEquals((int)12, (int)values.size());
        RemoteCache<K, V> cache = this.txRemoteCache();
        if (sync) {
            this.kvGenerator.assertValueEquals(values.get(0), cache.replace(keys.get(0), values.get(6)));
            this.kvGenerator.assertValueEquals(values.get(1), cache.replace(keys.get(1), values.get(7), 1L, TimeUnit.MINUTES));
            this.kvGenerator.assertValueEquals(values.get(2), cache.replace(keys.get(2), values.get(8), 2L, TimeUnit.MINUTES, 3L, TimeUnit.MINUTES));
            AssertJUnit.assertTrue((boolean)cache.replace(keys.get(3), values.get(3), values.get(9)));
            AssertJUnit.assertTrue((boolean)cache.replace(keys.get(4), values.get(4), values.get(10), 4L, TimeUnit.MINUTES));
            AssertJUnit.assertTrue((boolean)cache.replace(keys.get(5), values.get(5), values.get(11), 5L, TimeUnit.MINUTES, 6L, TimeUnit.MINUTES));
        } else {
            this.kvGenerator.assertValueEquals(values.get(0), cache.replaceAsync(keys.get(0), values.get(6)).get());
            this.kvGenerator.assertValueEquals(values.get(1), cache.replaceAsync(keys.get(1), values.get(7), 1L, TimeUnit.MINUTES).get());
            this.kvGenerator.assertValueEquals(values.get(2), cache.replaceAsync(keys.get(2), values.get(8), 2L, TimeUnit.MINUTES, 3L, TimeUnit.MINUTES).get());
            cache.replaceAsync(keys.get(3), values.get(3), values.get(9));
            cache.replaceAsync(keys.get(4), values.get(4), values.get(10), 4L, TimeUnit.MINUTES);
            cache.replaceAsync(keys.get(5), values.get(5), values.get(11), 5L, TimeUnit.MINUTES, 6L, TimeUnit.MINUTES);
        }
    }

    private void replaceWithVersion(List<K> keys, List<V> values, boolean sync) throws Exception {
        AssertJUnit.assertEquals((int)4, (int)keys.size());
        AssertJUnit.assertEquals((int)8, (int)values.size());
        RemoteCache<K, V> cache = this.txRemoteCache();
        if (sync) {
            MetadataValue value = cache.getWithMetadata(keys.get(0));
            AssertJUnit.assertTrue((boolean)cache.replaceWithVersion(keys.get(0), values.get(4), value.getVersion()));
            value = cache.getWithMetadata(keys.get(1));
            AssertJUnit.assertTrue((boolean)cache.replaceWithVersion(keys.get(1), values.get(5), value.getVersion(), 60));
            value = cache.getWithMetadata(keys.get(2));
            AssertJUnit.assertTrue((boolean)cache.replaceWithVersion(keys.get(2), values.get(6), value.getVersion(), 120, 180));
            value = cache.getWithMetadata(keys.get(3));
            AssertJUnit.assertTrue((boolean)cache.replaceWithVersion(keys.get(3), values.get(7), value.getVersion(), 4L, TimeUnit.MINUTES, 5L, TimeUnit.MINUTES));
        } else {
            MetadataValue value = cache.getWithMetadata(keys.get(0));
            AssertJUnit.assertTrue((boolean)((Boolean)cache.replaceWithVersionAsync(keys.get(0), values.get(4), value.getVersion()).get()));
            value = cache.getWithMetadata(keys.get(1));
            AssertJUnit.assertTrue((boolean)((Boolean)cache.replaceWithVersionAsync(keys.get(1), values.get(5), value.getVersion(), 60).get()));
            value = cache.getWithMetadata(keys.get(2));
            AssertJUnit.assertTrue((boolean)((Boolean)cache.replaceWithVersionAsync(keys.get(2), values.get(6), value.getVersion(), 120, 180).get()));
            value = cache.getWithMetadata(keys.get(3));
            AssertJUnit.assertTrue((boolean)cache.replaceWithVersion(keys.get(3), values.get(7), value.getVersion(), 4L, TimeUnit.MINUTES, 5L, TimeUnit.MINUTES));
        }
    }

    private void remove(List<K> keys, List<V> values, boolean sync) throws Exception {
        AssertJUnit.assertEquals((int)2, (int)keys.size());
        AssertJUnit.assertEquals((int)2, (int)values.size());
        RemoteCache<K, V> cache = this.txRemoteCache();
        if (sync) {
            cache.remove(keys.get(0));
            AssertJUnit.assertTrue((boolean)cache.remove(keys.get(1), values.get(1)));
        } else {
            cache.removeAsync(keys.get(0)).get();
            cache.removeAsync(keys.get(1), values.get(1));
        }
    }

    private void removeWithVersion(List<K> keys, List<V> values, boolean sync) throws Exception {
        AssertJUnit.assertEquals((int)1, (int)keys.size());
        AssertJUnit.assertEquals((int)1, (int)values.size());
        RemoteCache<K, V> cache = this.txRemoteCache();
        MetadataValue value = cache.getWithMetadata(keys.get(0));
        if (sync) {
            AssertJUnit.assertTrue((boolean)cache.removeWithVersion(keys.get(0), value.getVersion()));
        } else {
            AssertJUnit.assertTrue((boolean)((Boolean)cache.removeWithVersionAsync(keys.get(0), value.getVersion()).get()));
        }
    }

    private void compute(List<K> keys, List<V> values, boolean sync) {
        AssertJUnit.assertEquals((int)1, (int)keys.size());
        AssertJUnit.assertEquals((int)1, (int)values.size());
        AssertJUnit.assertTrue((boolean)sync);
        RemoteCache<K, V> cache = this.txRemoteCache();
        cache.compute(keys.get(0), (k, v) -> values.get(0));
    }

    private void computeIfAbsent(List<K> keys, List<V> values, boolean sync) {
        AssertJUnit.assertEquals((int)1, (int)keys.size());
        AssertJUnit.assertEquals((int)1, (int)values.size());
        AssertJUnit.assertTrue((boolean)sync);
        RemoteCache<K, V> cache = this.txRemoteCache();
        cache.computeIfAbsent(keys.get(0), k -> values.get(0));
    }

    private void computeIfPresent(List<K> keys, List<V> values, boolean sync) {
        AssertJUnit.assertEquals((int)1, (int)keys.size());
        AssertJUnit.assertEquals((int)2, (int)values.size());
        AssertJUnit.assertTrue((boolean)sync);
        RemoteCache<K, V> cache = this.txRemoteCache();
        cache.compute(keys.get(0), (k, v) -> values.get(1));
    }

    private void assertMetadataValue(V expected, MetadataValue<V> value, long lifespan, long maxIdle) {
        AssertJUnit.assertNotNull(value);
        this.kvGenerator.assertValueEquals(expected, value.getValue());
        AssertJUnit.assertEquals((long)lifespan, (long)value.getLifespan());
        AssertJUnit.assertEquals((long)maxIdle, (long)value.getMaxIdle());
    }

    private RemoteCache<K, V> txRemoteCache() {
        return this.client(0).getCache(CACHE_NAME);
    }

    private List<K> generateKeys(Method method, int count) {
        ArrayList<K> keys = new ArrayList<K>(count);
        for (int i = 0; i < count; ++i) {
            keys.add(this.kvGenerator.generateKey(method, i));
        }
        return keys;
    }

    private List<V> generateValues(Method method, int count) {
        ArrayList<V> keys = new ArrayList<V>(count);
        for (int i = 0; i < count; ++i) {
            keys.add(this.kvGenerator.generateValue(method, i));
        }
        return keys;
    }

    private static interface OperationStep<K, V> {
        public void execute(List<K> var1, List<V> var2, boolean var3) throws Exception;
    }

    private static interface Step<K, V> {
        public void execute(List<K> var1, List<V> var2);
    }

    private static interface DataCheck<K, V> {
        public void execute(List<K> var1, List<V> var2, boolean var3);
    }
}

