/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;

public abstract class BaseSegmentOwnershipTest
extends MultiHotRodServersTest {
    static final int NUM_SEGMENTS = 20;
    static final int NUM_OWNERS = 2;
    static final int NUM_SERVERS = 3;

    protected Map<Integer, Set<SocketAddress>> invertMap(Map<SocketAddress, Set<Integer>> segmentsByServer) {
        HashMap<Integer, Set<SocketAddress>> serversBySegment = new HashMap<Integer, Set<SocketAddress>>();
        for (Map.Entry<SocketAddress, Set<Integer>> entry : segmentsByServer.entrySet()) {
            for (Integer seg : entry.getValue()) {
                serversBySegment.computeIfAbsent(seg, v -> new HashSet()).add(entry.getKey());
            }
        }
        return serversBySegment;
    }

    protected abstract CacheMode getCacheMode();

    protected org.infinispan.configuration.cache.ConfigurationBuilder getCacheConfiguration() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = BaseSegmentOwnershipTest.getDefaultClusteredCacheConfig((CacheMode)this.getCacheMode(), (boolean)false);
        builder.clustering().hash().numOwners(2).numSegments(20);
        return HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
    }

    protected void createCacheManagers() throws Throwable {
        this.createHotRodServers(3, this.getCacheConfiguration());
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        return super.createHotRodClientConfigurationBuilder(host, serverPort);
    }
}

