/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.ControlledTimeService;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.MixedExpiryTest")
public class MixedExpiryTest
extends MultiHotRodServersTest {
    protected ControlledTimeService ts0;
    protected ControlledTimeService ts1;
    protected ControlledTimeService ts2;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = MixedExpiryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        this.configure(builder);
        this.createHotRodServers(3, builder);
        this.ts0 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.manager(0), TimeService.class, (Object)this.ts0, (boolean)true);
        this.ts1 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.manager(1), TimeService.class, (Object)this.ts1, (boolean)true);
        this.ts2 = new ControlledTimeService();
        TestingUtil.replaceComponent((CacheContainer)this.manager(2), TimeService.class, (Object)this.ts2, (boolean)true);
    }

    protected void configure(ConfigurationBuilder configurationBuilder) {
    }

    public void testMixedExpiryLifespan() {
        RemoteCacheManager client0 = this.client(0);
        RemoteCache remoteCache0 = client0.getCache();
        String key = "someKey";
        AssertJUnit.assertNull((Object)remoteCache0.put((Object)key, (Object)"value1", 1000L, TimeUnit.SECONDS, 1000L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals((String)"value1", (String)((String)remoteCache0.get((Object)key)));
        this.assertMetadataAndValue(remoteCache0.getWithMetadata((Object)key), "value1", 1000L, 1000L);
        AssertJUnit.assertEquals((String)"value1", (String)((String)remoteCache0.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"value2", -1L, TimeUnit.SECONDS, 1000L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((String)"value2", (String)((String)remoteCache0.get((Object)key)));
        this.assertMetadataAndValue(remoteCache0.getWithMetadata((Object)key), "value2", -1L, 1000L);
        AssertJUnit.assertEquals((String)"value2", (String)((String)remoteCache0.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"value3", -1L, TimeUnit.SECONDS, 1000L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((String)"value3", (String)((String)remoteCache0.get((Object)key)));
        this.assertMetadataAndValue(remoteCache0.getWithMetadata((Object)key), "value3", -1L, 1000L);
    }

    public void testMixedExpiryMaxIdle() {
        RemoteCacheManager client0 = this.client(0);
        RemoteCache remoteCache0 = client0.getCache();
        String key = "someKey";
        AssertJUnit.assertNull((Object)remoteCache0.put((Object)key, (Object)"value1", 1000L, TimeUnit.SECONDS, 1000L, TimeUnit.SECONDS));
        AssertJUnit.assertEquals((String)"value1", (String)((String)remoteCache0.get((Object)key)));
        this.assertMetadataAndValue(remoteCache0.getWithMetadata((Object)key), "value1", 1000L, 1000L);
        AssertJUnit.assertEquals((String)"value1", (String)((String)remoteCache0.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"value2", 1000L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((String)"value2", (String)((String)remoteCache0.get((Object)key)));
        this.assertMetadataAndValue(remoteCache0.getWithMetadata((Object)key), "value2", 1000L, -1L);
        AssertJUnit.assertEquals((String)"value2", (String)((String)remoteCache0.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"value3", 1000L, TimeUnit.SECONDS, -1L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((String)"value3", (String)((String)remoteCache0.get((Object)key)));
        this.assertMetadataAndValue(remoteCache0.getWithMetadata((Object)key), "value3", 1000L, -1L);
    }

    public void testMaxIdleRemovedOnAccess() throws InterruptedException, IOException {
        DataContainer dataContainer;
        RemoteCacheManager client0 = this.client(0);
        RemoteCache remoteCache0 = client0.getCache();
        String key = "someKey";
        Object keyStorage = this.cache(0).getAdvancedCache().getValueDataConversion().toStorage((Object)key);
        AssertJUnit.assertNull((Object)remoteCache0.put((Object)key, (Object)"value1", -1L, TimeUnit.MILLISECONDS, 100L, TimeUnit.MILLISECONDS));
        for (Cache cache : this.caches()) {
            dataContainer = cache.getAdvancedCache().getDataContainer();
            AssertJUnit.assertNotNull((Object)dataContainer.peek(keyStorage));
        }
        this.incrementAllTimeServices(150L, TimeUnit.MILLISECONDS);
        AssertJUnit.assertNull((Object)remoteCache0.get((Object)key));
        for (Cache cache : this.caches()) {
            dataContainer = cache.getAdvancedCache().getDataContainer();
            AssertJUnit.assertNull((Object)dataContainer.peek(keyStorage));
        }
    }

    private <V> void assertMetadataAndValue(MetadataValue<V> metadataValue, V value, long lifespanSeconds, long maxIdleSeconds) {
        AssertJUnit.assertEquals(value, (Object)metadataValue.getValue());
        AssertJUnit.assertEquals((long)lifespanSeconds, (long)metadataValue.getLifespan());
        AssertJUnit.assertEquals((long)maxIdleSeconds, (long)metadataValue.getMaxIdle());
    }

    private void incrementAllTimeServices(long time, TimeUnit unit) {
        for (ControlledTimeService cts : Arrays.asList(this.ts0, this.ts1, this.ts2)) {
            cts.advance(unit.toMillis(time));
        }
    }
}

