/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.lang.reflect.Method;
import java.net.SocketTimeoutException;
import java.util.concurrent.CompletableFuture;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.SocketTimeoutErrorTest")
public class SocketTimeoutErrorTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.customInterceptors().addInterceptor().interceptor((AsyncInterceptor)new TimeoutInducingInterceptor()).after(EntryWrappingInterceptor.class);
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)builder));
    }

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager, builder);
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        builder.socketTimeout(2000);
        builder.maxRetries(0);
        return new RemoteCacheManager(builder.build());
    }

    public void testErrorWhileDoingPut(Method m) {
        RemoteCache cache = this.remoteCacheManager.getCache();
        cache.put((Object)TestingUtil.k((Method)m), (Object)1);
        AssertJUnit.assertEquals((int)1, (int)((Integer)cache.get((Object)TestingUtil.k((Method)m))));
        Exceptions.expectException(TransportException.class, SocketTimeoutException.class, () -> cache.put((Object)"FailFailFail", (Object)2));
        cache.put((Object)"dos", (Object)2);
        AssertJUnit.assertEquals((int)2, (int)((Integer)cache.get((Object)"dos")));
        ((TimeoutInducingInterceptor)TestingUtil.extractInterceptorChain((Cache)this.cache).findInterceptorWithClass(TimeoutInducingInterceptor.class)).stopBlocking();
    }

    public static class TimeoutInducingInterceptor
    extends BaseCustomAsyncInterceptor {
        public final CompletableFuture<Void> delay = new CompletableFuture();

        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            if (this.unmarshall(command.getKey()).equals("FailFailFail")) {
                return TimeoutInducingInterceptor.asyncValue(this.delay);
            }
            return super.visitPutKeyValueCommand(ctx, command);
        }

        private String unmarshall(Object key) throws Exception {
            return (String)new ProtoStreamMarshaller().objectFromByteBuffer(((WrappedByteArray)key).getBytes());
        }

        private void stopBlocking() {
            this.delay.complete(null);
        }
    }
}

