/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.function.Supplier;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.SslConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.wildfly.security.keystore.KeyStoreUtil;
import org.wildfly.security.provider.util.ProviderUtil;

@Test(testName="client.hotrod.SslTest", groups={"functional"})
@CleanupAfterMethod
public class SslTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(SslTest.class);
    public static final char[] STORE_PASSWORD = "secret".toCharArray();
    public static final char[] ALT_CERTIFICATE_PASSWORD = "changeme".toCharArray();
    RemoteCache<String, String> defaultRemote;
    protected RemoteCacheManager remoteCacheManager;
    protected HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.getCache();
        return this.cacheManager;
    }

    protected void initServerAndClient(boolean sslServer, boolean sslClient, boolean requireClientAuth, boolean clientAuth, boolean altCertPassword, boolean usePEM) {
        HotRodServerConfigurationBuilder serverBuilder = HotRodTestingUtil.getDefaultHotRodConfiguration();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        String serverKeyStore = tccl.getResource(altCertPassword ? "keystore_server.jks" : "keystore_server.p12").getPath();
        String serverTrustStore = tccl.getResource("ca.p12").getPath();
        org.infinispan.server.core.configuration.SslConfigurationBuilder serverSSLConfig = serverBuilder.ssl().enabled(sslServer).keyStoreFileName(serverKeyStore).keyStorePassword(STORE_PASSWORD).keyStoreType(altCertPassword ? "JCEKS" : "PKCS12");
        if (altCertPassword) {
            serverSSLConfig.keyStoreCertificatePassword(ALT_CERTIFICATE_PASSWORD);
        }
        if (requireClientAuth) {
            serverSSLConfig.requireClientAuth(true).trustStoreFileName(serverTrustStore).trustStoreType("PKCS12").trustStorePassword(STORE_PASSWORD);
        }
        this.hotrodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (HotRodServerConfigurationBuilder)serverBuilder);
        log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        String clientKeyStore = tccl.getResource(altCertPassword ? "keystore_client.jks" : "keystore_client.p12").getPath();
        String clientTrustStore = tccl.getResource("ca.p12").getPath();
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        SslConfigurationBuilder clientSSLConfig = clientBuilder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue()).socketTimeout(3000).connectionPool().maxActive(1).security().authentication().disable().ssl();
        if (sslClient) {
            if (usePEM) {
                try {
                    Path pem = Paths.get(clientTrustStore, new String[0]).getParent().resolve("ca.pem");
                    KeyStore keyStore = KeyStoreUtil.loadKeyStore((Supplier)ProviderUtil.INSTALLED_PROVIDERS, null, (FileInputStream)new FileInputStream(clientTrustStore), (String)clientTrustStore, (char[])STORE_PASSWORD);
                    String alias = keyStore.aliases().nextElement();
                    Certificate certificate = keyStore.getCertificate(alias);
                    JcaPEMWriter writer = new JcaPEMWriter((Writer)Files.newBufferedWriter(pem, new OpenOption[0]));
                    writer.writeObject((Object)certificate);
                    writer.close();
                    clientSSLConfig.trustStoreFileName(pem.toString()).trustStoreType("PEM");
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else {
                clientSSLConfig.trustStoreFileName(clientTrustStore).trustStorePassword(STORE_PASSWORD).trustStoreType("PKCS12");
            }
            if (clientAuth) {
                clientSSLConfig.keyStoreFileName(clientKeyStore).keyStorePassword(STORE_PASSWORD).keyStoreType(altCertPassword ? "JCEKS" : "PKCS12");
                if (altCertPassword) {
                    clientSSLConfig.keyStoreCertificatePassword(ALT_CERTIFICATE_PASSWORD);
                }
            }
        }
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.defaultRemote = this.remoteCacheManager.getCache();
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        this.remoteCacheManager = null;
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        this.hotrodServer = null;
        super.teardown();
    }

    public void testSSLServerSSLClient() throws Exception {
        this.initServerAndClient(true, true, false, false, false, false);
        this.defaultRemote.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)this.defaultRemote.get((Object)"k")));
    }

    public void testSSLServerSSLClientWithPEM() throws Exception {
        this.initServerAndClient(true, true, false, false, false, true);
        this.defaultRemote.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)this.defaultRemote.get((Object)"k")));
    }

    @Test(expectedExceptions={TransportException.class})
    public void testSSLServerPlainClient() throws Exception {
        this.initServerAndClient(true, false, false, false, false, false);
    }

    @Test(expectedExceptions={TransportException.class})
    public void testPlainServerSSLClient() throws Exception {
        this.initServerAndClient(false, true, false, false, false, false);
    }

    public void testClientAuth() throws Exception {
        this.initServerAndClient(true, true, true, true, false, false);
        this.defaultRemote.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)this.defaultRemote.get((Object)"k")));
    }

    public void testClientAuthWithAnonClient() throws Exception {
        Exceptions.expectExceptionNonStrict(TransportException.class, IOException.class, () -> this.initServerAndClient(true, true, true, false, false, false));
    }

    public void testClientAuthAltCertPassword() throws Exception {
        this.initServerAndClient(true, true, true, true, true, false);
        this.defaultRemote.put((Object)"k", (Object)"v");
        AssertJUnit.assertEquals((String)"v", (String)((String)this.defaultRemote.get((Object)"k")));
    }
}

