/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.testng.annotations.Test;

@Test(groups={"functional", "smoke"}, testName="client.hotrod.event.ClientEventsWithIgnoreNotificationsFlagTest")
public class ClientEventsWithIgnoreNotificationsFlagTest
extends SingleHotRodServerTest {
    public void testCreatedEvent() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).put((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).put((Object)2, (Object)"two");
            l.expectNoEvents();
        });
    }

    public void testModifiedEvent() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).put((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).put((Object)1, (Object)"newone");
            l.expectNoEvents();
        });
    }

    public void testRemovedEvent() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).remove((Object)1);
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).put((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).remove((Object)1);
            l.expectNoEvents();
        });
    }

    public void testReplaceEvents() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).replace((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).put((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).replace((Object)1, (Object)"newone");
            l.expectNoEvents();
        });
    }

    public void testPutIfAbsentEvents() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).putIfAbsent((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).putIfAbsent((Object)1, (Object)"newone");
            l.expectNoEvents();
        });
    }

    public void testReplaceIfUnmodifiedEvents() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).replaceWithVersion((Object)1, (Object)"one", 0L);
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).putIfAbsent((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).replaceWithVersion((Object)1, (Object)"one", 0L);
            l.expectNoEvents();
        });
    }

    public void testRemoveIfUnmodifiedEvents() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).removeWithVersion((Object)1, 0L);
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).putIfAbsent((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).removeWithVersion((Object)1, 0L);
            l.expectNoEvents();
        });
    }

    public void testClearEvents() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).put((Object)1, (Object)"one");
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).put((Object)2, (Object)"two");
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).put((Object)3, (Object)"three");
            l.expectNoEvents();
            remote.withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}).clear();
            l.expectNoEvents();
        });
    }
}

