/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.net.SocketTimeoutException;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.SocketTimeoutErrorTest;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.EventSocketTimeoutTest")
public class EventSocketTimeoutTest
extends SingleHotRodServerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.customInterceptors().addInterceptor().interceptor((AsyncInterceptor)new SocketTimeoutErrorTest.TimeoutInducingInterceptor()).after(EntryWrappingInterceptor.class);
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)builder));
    }

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder builder = new HotRodServerConfigurationBuilder();
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager, builder);
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host(this.hotrodServer.getHost()).port(this.hotrodServer.getPort().intValue());
        builder.socketTimeout(1000);
        builder.maxRetries(0);
        return new RemoteCacheManager(builder.build());
    }

    public void testSocketTimeoutWithEvent() {
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache());
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)"uno", (Object)1);
            l.expectOnlyCreatedEvent("uno");
            Exceptions.expectException(TransportException.class, SocketTimeoutException.class, () -> remote.put((Object)"FailFailFail", (Object)99));
            l.expectNoEvents();
            remote.put((Object)"dos", (Object)2);
            l.expectOnlyCreatedEvent("dos");
        });
    }
}

