/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.io.IOException;
import org.infinispan.protostream.MessageMarshaller;
import org.infinispan.query.dsl.embedded.testdomain.hsearch.LimitsHS;

public class EmbeddedLimitsMarshaller
implements MessageMarshaller<LimitsHS> {
    public String getTypeName() {
        return "sample_bank_account.Account.Limits";
    }

    public Class<LimitsHS> getJavaClass() {
        return LimitsHS.class;
    }

    public LimitsHS readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        double maxDailyLimit = reader.readDouble("maxDailyLimit");
        double maxTransactionLimit = reader.readDouble("maxTransactionLimit");
        String[] payees = (String[])reader.readArray("payees", String.class);
        LimitsHS limits = new LimitsHS();
        limits.setMaxDailyLimit(Double.valueOf(maxDailyLimit));
        limits.setMaxTransactionLimit(Double.valueOf(maxTransactionLimit));
        limits.setPayees(payees);
        return limits;
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, LimitsHS limits) throws IOException {
        writer.writeDouble("maxDailyLimit", limits.getMaxDailyLimit());
        writer.writeDouble("maxTransactionLimit", limits.getMaxTransactionLimit());
        writer.writeArray("payees", (Object[])limits.getPayees(), String.class);
    }
}

