/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import java.util.concurrent.CompletionStage;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.NearCacheMode;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.near.AssertsNearCache;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.util.concurrent.CompletionStages;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.near.EvictInvalidatedNearCacheTest")
public class EvictInvalidatedNearCacheTest
extends SingleHotRodServerTest {
    private int entryCount;
    private boolean bloomFilter;
    AssertsNearCache<Integer, String> assertClient;

    EvictInvalidatedNearCacheTest entryCount(int entryCount) {
        this.entryCount = entryCount;
        return this;
    }

    EvictInvalidatedNearCacheTest bloomFilter(boolean bloomFilter) {
        this.bloomFilter = bloomFilter;
        return this;
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new EvictInvalidatedNearCacheTest().entryCount(1).bloomFilter(false), new EvictInvalidatedNearCacheTest().entryCount(1).bloomFilter(true), new EvictInvalidatedNearCacheTest().entryCount(20).bloomFilter(false), new EvictInvalidatedNearCacheTest().entryCount(20).bloomFilter(true)};
    }

    protected String parameters() {
        return "maxEntries=" + this.entryCount + ", bloomFilter=" + this.bloomFilter;
    }

    @Override
    protected void teardown() {
        if (this.assertClient != null) {
            this.assertClient.stop();
            this.assertClient = null;
        }
        super.teardown();
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() {
        super.clearContent();
        RemoteCache remoteCache = this.remoteCacheManager.getCache();
        remoteCache.clear();
        if (this.bloomFilter) {
            CompletionStages.join((CompletionStage)((InternalRemoteCache)remoteCache).updateBloomFilter());
        }
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        this.assertClient = this.createClient();
        return this.assertClient.manager;
    }

    protected <K, V> AssertsNearCache<K, V> createClient() {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue());
        NearCacheConfigurationBuilder nearCacheConfigurationBuilder = builder.nearCache().mode(this.getNearCacheMode()).maxEntries(this.entryCount);
        if (this.bloomFilter) {
            builder.connectionPool().maxActive(1);
            nearCacheConfigurationBuilder.bloomFilter(true);
        }
        return AssertsNearCache.create(this.cache(), builder);
    }

    protected NearCacheMode getNearCacheMode() {
        return NearCacheMode.INVALIDATED;
    }

    public void testEvictAfterReachingMax() {
        this.assertClient.expectNoNearEvents();
        for (int i = 0; i < this.entryCount; ++i) {
            this.assertClient.put(i, "v1").expectNearPreemptiveRemove(i);
            this.assertClient.get(i, "v1").expectNearGetNull(i).expectNearPutIfAbsent(i, "v1");
        }
        int extraKey = this.entryCount + 1;
        this.assertClient.put(extraKey, "v1").expectNearPreemptiveRemove(extraKey);
        this.assertClient.get(extraKey, "v1").expectNearGetNull(extraKey).expectNearPutIfAbsent(extraKey, "v1");
        AssertJUnit.assertEquals((int)this.entryCount, (int)this.assertClient.nearCacheSize());
    }
}

