/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.Collections;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AddressPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.testdomain.Address;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.MultiHotRodServerQueryTest", groups={"functional"})
public class MultiHotRodServerQueryTest
extends MultiHotRodServersTest {
    protected RemoteCache<Integer, User> remoteCache0;
    protected RemoteCache<Integer, User> remoteCache1;

    protected boolean useTransactions() {
        return false;
    }

    @Override
    protected void modifyGlobalConfiguration(GlobalConfigurationBuilder builder) {
        super.modifyGlobalConfiguration(builder);
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)MultiHotRodServerQueryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)this.useTransactions()));
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("sample_bank_account.User");
        this.createHotRodServers(3, builder);
        this.waitForClusterToForm();
        this.remoteCache0 = this.client(0).getCache();
        this.remoteCache1 = this.client(1).getCache();
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDomainSCI.INSTANCE;
    }

    @BeforeClass(alwaysRun=true)
    protected void populateCache() {
        UserPB user1 = new UserPB();
        user1.setId(1);
        user1.setName("Tom");
        user1.setSurname("Cat");
        user1.setGender(User.Gender.MALE);
        user1.setAge(5);
        user1.setAccountIds(Collections.singleton(12));
        AddressPB address1 = new AddressPB();
        address1.setStreet("Dark Alley");
        address1.setPostCode("1234");
        user1.setAddresses(Collections.singletonList(address1));
        this.remoteCache0.put((Object)1, (Object)user1);
        AssertJUnit.assertNotNull((Object)this.remoteCache0.get((Object)1));
        AssertJUnit.assertNotNull((Object)this.remoteCache1.get((Object)1));
        UserPB user2 = new UserPB();
        user2.setId(2);
        user2.setName("Adrian");
        user2.setSurname("Nistor");
        user2.setGender(User.Gender.MALE);
        user2.setAge(22);
        AddressPB address2 = new AddressPB();
        address2.setStreet("Old Street");
        address2.setPostCode("XYZ");
        user2.setAddresses(Collections.singletonList(address2));
        this.remoteCache1.put((Object)2, (Object)user2);
        AssertJUnit.assertNotNull((Object)this.remoteCache0.get((Object)2));
        AssertJUnit.assertNotNull((Object)this.remoteCache1.get((Object)2));
        this.client(0).getCache().put((Object)"dummy", (Object)"a primitive value cannot be queried");
    }

    public void testAttributeQuery() {
        User fromCache = (User)this.remoteCache0.get((Object)1);
        AssertJUnit.assertNotNull((Object)fromCache);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache1);
        Query query = qf.create("FROM sample_bank_account.User WHERE name = 'Tom'");
        List list = query.execute().list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(UserPB.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    public void testGroupByQuery() {
        User fromCache = (User)this.remoteCache0.get((Object)1);
        AssertJUnit.assertNotNull((Object)fromCache);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache0);
        Query query = qf.create("SELECT name, COUNT(age) FROM sample_bank_account.User WHERE age >= 5 GROUP BY name ORDER BY name ASC");
        List list = query.execute().list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)2, (int)list.size());
        AssertJUnit.assertEquals(Object[].class, ((Object[])list.get(0)).getClass());
        AssertJUnit.assertEquals(Object[].class, ((Object[])list.get(1)).getClass());
        AssertJUnit.assertEquals((Object)"Adrian", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"Tom", (Object)((Object[])list.get(1))[0]);
    }

    public void testEmbeddedAttributeQuery() {
        QueryFactory qf = Search.getQueryFactory(this.remoteCache1);
        Query query = qf.create("FROM sample_bank_account.User u WHERE u.addresses.postCode = '1234'");
        List list = query.execute().list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(UserPB.class, ((User)list.get(0)).getClass());
        this.assertUser1((User)list.get(0));
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp=".*ISPN028503: Property addresses can not be selected from type sample_bank_account.User since it is an embedded entity.")
    public void testInvalidEmbeddedAttributeQuery() {
        QueryFactory qf = Search.getQueryFactory(this.remoteCache1);
        Query q = qf.create("SELECT addresses FROM sample_bank_account.User");
        q.execute();
    }

    public void testProjections() {
        User fromCache = (User)this.remoteCache0.get((Object)1);
        this.assertUser1(fromCache);
        QueryFactory qf = Search.getQueryFactory(this.remoteCache1);
        Query query = qf.create("SELECT name, surname FROM sample_bank_account.User WHERE name = 'Tom'");
        List list = query.execute().list();
        AssertJUnit.assertNotNull((Object)list);
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals(Object[].class, ((Object[])list.get(0)).getClass());
        AssertJUnit.assertEquals((Object)"Tom", (Object)((Object[])list.get(0))[0]);
        AssertJUnit.assertEquals((Object)"Cat", (Object)((Object[])list.get(0))[1]);
    }

    private void assertUser1(User user) {
        AssertJUnit.assertNotNull((Object)user);
        AssertJUnit.assertEquals((int)1, (int)user.getId());
        AssertJUnit.assertEquals((String)"Tom", (String)user.getName());
        AssertJUnit.assertEquals((String)"Cat", (String)user.getSurname());
        AssertJUnit.assertEquals((Object)User.Gender.MALE, (Object)user.getGender());
        AssertJUnit.assertNotNull((Object)user.getAccountIds());
        AssertJUnit.assertEquals((int)1, (int)user.getAccountIds().size());
        AssertJUnit.assertTrue((boolean)user.getAccountIds().contains(12));
        AssertJUnit.assertNotNull((Object)user.getAddresses());
        AssertJUnit.assertEquals((int)1, (int)user.getAddresses().size());
        AssertJUnit.assertEquals((String)"Dark Alley", (String)((Address)user.getAddresses().get(0)).getStreet());
        AssertJUnit.assertEquals((String)"1234", (String)((Address)user.getAddresses().get(0)).getPostCode());
    }
}

