/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.NotIndexedSCI;
import org.infinispan.client.hotrod.query.testdomain.protobuf.ModelFactoryPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.AbstractQueryDslTest;
import org.infinispan.query.dsl.embedded.testdomain.ModelFactory;
import org.infinispan.query.dsl.embedded.testdomain.NotIndexed;
import org.infinispan.search.mapper.mapping.SearchMapping;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.RemoteQueryDisableIndexingTest")
public class RemoteQueryDisableIndexingTest
extends AbstractQueryDslTest {
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected Cache<Object, Object> cache;

    @BeforeClass
    protected void populateCache() {
        this.getCacheForWrite().put((Object)"notIndexed1", (Object)new NotIndexed("testing 123"));
        this.getCacheForWrite().put((Object)"notIndexed2", (Object)new NotIndexed("xyz"));
    }

    protected QueryFactory getQueryFactory() {
        return Search.getQueryFactory(this.remoteCache);
    }

    protected ModelFactory getModelFactory() {
        return ModelFactoryPB.INSTANCE;
    }

    protected RemoteCache<Object, Object> getCacheForQuery() {
        return this.remoteCache;
    }

    protected Cache<Object, Object> getEmbeddedCache() {
        return this.cache;
    }

    protected int getNodesCount() {
        return 1;
    }

    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().clusteredDefault();
        globalBuilder.serialization().addContextInitializers(new SerializationContextInitializer[]{TestDomainSCI.INSTANCE, NotIndexedSCI.INSTANCE});
        this.createClusteredCaches(this.getNodesCount(), globalBuilder, this.getConfigurationBuilder(), true, new String[0]);
        this.cache = this.manager(0).getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue()).addContextInitializers(new SerializationContextInitializer[]{TestDomainSCI.INSTANCE, NotIndexedSCI.INSTANCE});
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("sample_bank_account.User").addIndexedEntity("sample_bank_account.Account").addIndexedEntity("sample_bank_account.Transaction");
        return builder;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        this.remoteCacheManager = null;
        HotRodClientTestingUtil.killServers(this.hotRodServer);
        this.hotRodServer = null;
    }

    public void testEmptyIndexIsPresent() {
        SearchMapping searchMapping = (SearchMapping)TestingUtil.extractComponent(this.cache, SearchMapping.class);
        AssertJUnit.assertNotNull((Object)searchMapping.indexedEntity("sample_bank_account.User"));
        AssertJUnit.assertNotNull((Object)searchMapping.indexedEntity("sample_bank_account.Account"));
        AssertJUnit.assertNotNull((Object)searchMapping.indexedEntity("sample_bank_account.Transaction"));
        AssertJUnit.assertEquals((int)3, (int)searchMapping.allIndexedEntities().size());
    }

    public void testEqNonIndexedType() {
        Query q = this.getQueryFactory().create("from sample_bank_account.NotIndexed where notIndexedField = 'testing 123'");
        List list = q.execute().list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"testing 123", (String)((NotIndexed)list.get((int)0)).notIndexedField);
    }
}

