/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.nio.charset.StandardCharsets;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.XMLStringConfiguration;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.query.dsl.Query;
import org.infinispan.server.core.admin.AdminOperationsHandler;
import org.infinispan.server.core.admin.embeddedserver.EmbeddedServerAdminOperationHandler;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.RemoteQueryRepeatedMappingTest", groups={"functional"})
public class RemoteQueryRepeatedMappingTest
extends SingleHotRodServerTest {
    private static final String CACHE_NAME = RemoteQueryRepeatedMappingTest.class.getName();
    private static final String SCHEMA_FILE = "indexed-repeated.proto";

    @Override
    protected HotRodServer createHotRodServer() {
        HotRodServerConfigurationBuilder serverBuilder = new HotRodServerConfigurationBuilder();
        serverBuilder.adminOperationsHandler((AdminOperationsHandler)new EmbeddedServerAdminOperationHandler());
        return HotRodClientTestingUtil.startHotRodServer(this.cacheManager, serverBuilder);
    }

    @Override
    protected RemoteCacheManager getRemoteCacheManager() {
        return super.getRemoteCacheManager();
    }

    @Test
    public void testCreateAndQuery() throws Exception {
        this.registerProtoBuf();
        RemoteCache cache = ((RemoteCacheManagerAdmin)this.remoteCacheManager.administration().withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.VOLATILE})).createCache(CACHE_NAME, (BasicConfiguration)this.createCacheXMLConfig());
        DataFormat dataFormat = DataFormat.builder().keyType(MediaType.APPLICATION_JSON).valueType(MediaType.APPLICATION_JSON).build();
        RemoteCache jsonCache = cache.withDataFormat(dataFormat);
        jsonCache.put((Object)this.keyAsJson(), (Object)this.valueAsJson());
        Query querySlowChildren = Search.getQueryFactory((RemoteCache)cache).create("SELECT COUNT(*) FROM Parent p WHERE p.slowChildren.id = 0");
        Query queryFastChildren = Search.getQueryFactory((RemoteCache)cache).create("SELECT COUNT(*) FROM Parent p WHERE p.fastChildren.id = 10");
        Query queryFieldChildren = Search.getQueryFactory((RemoteCache)cache).create("SELECT COUNT(*) FROM Parent p WHERE p.fieldLessChildren.id = 0");
        Query queryNotIndexedWithFieldChildren = Search.getQueryFactory((RemoteCache)cache).create("SELECT COUNT(*) FROM Parent p WHERE p.notIndexedWithFieldChild.id = 37");
        AssertJUnit.assertEquals((long)1L, (long)querySlowChildren.execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)1L, (long)queryFastChildren.execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)1L, (long)queryFieldChildren.execute().hitCount().orElse(-1L));
        AssertJUnit.assertEquals((long)1L, (long)queryNotIndexedWithFieldChildren.execute().hitCount().orElse(-1L));
    }

    private byte[] keyAsJson() {
        return Json.object().set("_type", (Object)"int32").set("_value", (Object)"1").toString().getBytes(StandardCharsets.UTF_8);
    }

    private byte[] valueAsJson() {
        Json parent = Json.object().set("_type", (Object)"Parent").set("id", (Object)1).set("name", (Object)"Kim").set("slowChildren", Json.array((Object[])new Object[]{Json.object().set("id", (Object)"0")})).set("fastChildren", Json.array((Object[])new Object[]{Json.object().set("id", (Object)"10")})).set("fieldLessChildren", Json.array((Object[])new Object[]{Json.object().set("id", (Object)"0")})).set("notIndexedWithFieldChild", Json.array((Object[])new Object[]{Json.object().set("id", (Object)"37")}));
        return parent.toString().getBytes(StandardCharsets.UTF_8);
    }

    private void registerProtoBuf() throws Exception {
        RemoteCache protoCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        String protobuf = Util.getResourceAsString((String)SCHEMA_FILE, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        protoCache.put((Object)SCHEMA_FILE, (Object)protobuf);
    }

    private XMLStringConfiguration createCacheXMLConfig() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.encoding().mediaType("application/x-protostream");
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntities(new String[]{"Parent"});
        String config = builder.build().toXMLString(CACHE_NAME);
        return new XMLStringConfiguration(config);
    }
}

