/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.util.Date;
import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AccountPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.UserPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.embedded.testdomain.Account;
import org.infinispan.query.dsl.embedded.testdomain.User;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.TwoCachesSharedIndexTest", groups={"functional"})
public class TwoCachesSharedIndexTest
extends MultiHotRodServersTest {
    private static final String USER_CACHE = "users";
    private static final String ACCOUNT_CACHE = "accounts";

    public Configuration buildIndexedConfig() {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)TwoCachesSharedIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("sample_bank_account.User").addIndexedEntity("sample_bank_account.Account");
        return builder.build();
    }

    public Configuration getNonIndexLockConfig() {
        return TwoCachesSharedIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false).build();
    }

    public Configuration getNonIndexDataConfig() {
        return TwoCachesSharedIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false).build();
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        this.createHotRodServers(2, defaultConfiguration);
        this.cacheManagers.forEach(cm -> {
            cm.defineConfiguration(USER_CACHE, this.buildIndexedConfig());
            cm.defineConfiguration(ACCOUNT_CACHE, this.buildIndexedConfig());
            cm.getCache(USER_CACHE);
            cm.getCache(ACCOUNT_CACHE);
        });
        this.waitForClusterToForm(new String[]{USER_CACHE, ACCOUNT_CACHE});
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDomainSCI.INSTANCE;
    }

    @Test
    public void testWithUserCache() {
        RemoteCache userCache = this.client(0).getCache(USER_CACHE);
        userCache.put((Object)1, (Object)this.getUserPB());
        Query query = Search.getQueryFactory((RemoteCache)userCache).create("FROM sample_bank_account.User WHERE name = 'John'");
        List users = query.execute().list();
        Assert.assertEquals((String)"John", (String)((User)users.iterator().next()).getName());
    }

    @Test
    public void testWithAccountCache() {
        RemoteCache accountCache = this.client(0).getCache(ACCOUNT_CACHE);
        accountCache.put((Object)1, (Object)this.getAccountPB());
        Query query = Search.getQueryFactory((RemoteCache)accountCache).create("FROM sample_bank_account.Account WHERE description = 'account1'");
        List accounts = query.execute().list();
        Assert.assertEquals((String)((Account)accounts.iterator().next()).getDescription(), (String)"account1");
    }

    private AccountPB getAccountPB() {
        AccountPB accountPB = new AccountPB();
        accountPB.setId(1);
        accountPB.setDescription("account1");
        accountPB.setCreationDate(new Date());
        return accountPB;
    }

    private UserPB getUserPB() {
        UserPB userPB = new UserPB();
        userPB.setName("John");
        userPB.setSurname("Doe");
        return userPB;
    }
}

