/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.infinispan.client.hotrod.HitsAwareCacheManagersTest;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.retry.SCIImpl;
import org.infinispan.client.hotrod.retry.StableControlledConsistentHashFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.retry.CompleteShutdownDistRetryTest")
public class CompleteShutdownDistRetryTest
extends HitsAwareCacheManagersTest {
    List<SocketAddress> addrs;
    List<byte[]> keys;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = this.getConfiguration();
        this.createHotRodServers(3, builder);
    }

    protected GlobalConfigurationBuilder defaultGlobalConfigurationBuilder() {
        GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
        gcb.serialization().addContextInitializer((SerializationContextInitializer)new SCIImpl());
        return gcb;
    }

    @Override
    protected void assertOnlyServerHit(SocketAddress serverAddress) {
        super.assertOnlyServerHit(serverAddress);
        this.resetStats();
    }

    public void testRetryAfterCompleteShutdown() {
        RemoteCache client = this.client(0).getCache();
        int initialServerPort = ((HotRodServer)this.addr2hrServer.values().iterator().next()).getPort();
        this.addrs = this.getSocketAddressList();
        this.keys = this.genKeys();
        this.assertNoHits();
        this.assertPutAndGet((RemoteCache<byte[], String>)client, 0, "zero");
        this.assertPutAndGet((RemoteCache<byte[], String>)client, 1, "one");
        this.assertPutAndGet((RemoteCache<byte[], String>)client, 2, "two");
        this.killServer();
        this.killServer();
        AssertJUnit.assertNull((Object)client.get((Object)this.keys.get(0)));
        AssertJUnit.assertNull((Object)client.get((Object)this.keys.get(1)));
        this.resetStats();
        AssertJUnit.assertEquals((String)"two", (String)((String)client.get((Object)this.keys.get(2))));
        this.assertOnlyServerHit(this.addrs.get(2));
        this.killServer();
        try {
            AssertJUnit.assertEquals((String)"two", (String)((String)client.get((Object)this.keys.get(2))));
            AssertJUnit.fail((String)"Should have thrown exception");
        }
        catch (TransportException transportException) {
            // empty catch block
        }
        this.resetStats();
        this.addHotRodServer(this.getConfiguration(), initialServerPort);
        this.addHotRodServer(this.getConfiguration());
        this.addHotRodServer(this.getConfiguration());
        this.addInterceptors();
        this.keys = this.genKeys();
        this.addrs = this.getSocketAddressList();
        this.assertNoHits();
        this.assertPutAndGet((RemoteCache<byte[], String>)client, 0, "zero");
        this.assertPutAndGet((RemoteCache<byte[], String>)client, 1, "one");
        this.assertPutAndGet((RemoteCache<byte[], String>)client, 2, "two");
    }

    private void assertPutAndGet(RemoteCache<byte[], String> client, int nodeIndex, String value) {
        client.put((Object)this.keys.get(nodeIndex), (Object)value);
        this.assertOnlyServerHit(this.addrs.get(nodeIndex));
        AssertJUnit.assertEquals((String)value, (String)((String)client.get((Object)this.keys.get(nodeIndex))));
        this.assertOnlyServerHit(this.addrs.get(nodeIndex));
    }

    private List<byte[]> genKeys() {
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (Map.Entry entry : this.addr2hrServer.entrySet()) {
            keys.add(HotRodClientTestingUtil.getKeyForServer((HotRodServer)entry.getValue()));
        }
        return keys;
    }

    private List<SocketAddress> getSocketAddressList() {
        return new ArrayList<SocketAddress>(this.addr2hrServer.keySet());
    }

    private ConfigurationBuilder getConfiguration() {
        ConfigurationBuilder builder = CompleteShutdownDistRetryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        builder.clustering().hash().numSegments(3).numOwners(1);
        builder.clustering().hash().consistentHashFactory((ConsistentHashFactory)new StableControlledConsistentHashFactory());
        return HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)builder);
    }
}

