/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.retry;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.retry.AbstractRetryTest;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.retry.SocketTimeoutFailureRetryTest")
@CleanupAfterTest
public class SocketTimeoutFailureRetryTest
extends AbstractRetryTest {
    @Override
    protected org.infinispan.configuration.cache.ConfigurationBuilder getCacheConfig() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)SocketTimeoutFailureRetryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        return builder;
    }

    @Override
    protected RemoteCacheManager createRemoteCacheManager(int port) {
        ConfigurationBuilder builder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        builder.connectionTimeout(2000).socketTimeout(2000).maxRetries(1).addServer().host("127.0.0.1").port(port);
        return new InternalRemoteCacheManager(builder.build());
    }

    @Override
    protected void addInterceptors(Cache<?, ?> cache) {
        super.addInterceptors(cache);
        TestingUtil.extractInterceptorChain(cache).addInterceptorAfter((AsyncInterceptor)new DelayingInterceptor(), EntryWrappingInterceptor.class);
    }

    public void testRetrySocketTimeout() {
        Integer key = 1;
        this.remoteCache.put((Object)key, (Object)"v1");
        AssertJUnit.assertEquals((Object)"v1", (Object)this.remoteCache.get((Object)1));
        AdvancedCache<?, ?> nextCache = this.cacheToHit(key);
        DelayingInterceptor interceptor = (DelayingInterceptor)TestingUtil.extractInterceptorChain(nextCache).findInterceptorExtending(DelayingInterceptor.class);
        CompletableFuture<Void> delay = new CompletableFuture<Void>();
        interceptor.delayNextRequest(delay);
        AssertJUnit.assertEquals((long)0L, (long)this.remoteCacheManager.getChannelFactory().getRetries());
        AssertJUnit.assertEquals((Object)"v1", (Object)this.remoteCache.get((Object)key));
        AssertJUnit.assertEquals((long)1L, (long)this.remoteCacheManager.getChannelFactory().getRetries());
        delay.complete(null);
    }

    public static class DelayingInterceptor
    extends BaseCustomAsyncInterceptor {
        static volatile AtomicReference<CompletionStage<Void>> delayNextRequest = new AtomicReference();

        public void delayNextRequest(CompletionStage<Void> delayStage) {
            delayNextRequest.set(delayStage);
        }

        public Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) {
            CompletionStage delay = delayNextRequest.getAndSet(null);
            return this.asyncInvokeNext(ctx, (VisitableCommand)command, delay);
        }
    }
}

