/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.stress;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"stress"})
public abstract class AbstractGetAllPerfTest
extends MultipleCacheManagersTest {
    protected HotRodServer[] hotrodServers;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected final long millisecondsToRun = TimeUnit.MINUTES.toMillis(1L);

    protected abstract int numberOfHotRodServers();

    protected abstract org.infinispan.configuration.cache.ConfigurationBuilder clusterConfig();

    protected void createCacheManagers() throws Throwable {
        int numServers = this.numberOfHotRodServers();
        this.hotrodServers = new HotRodServer[numServers];
        this.createCluster(HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.clusterConfig()), this.numberOfHotRodServers());
        for (int i = 0; i < numServers; ++i) {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.get(i);
            this.hotrodServers[i] = HotRodClientTestingUtil.startHotRodServer(cm);
        }
        String servers = HotRodClientTestingUtil.getServersString(this.hotrodServers);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServers(servers);
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        this.remoteCacheManager = null;
        HotRodClientTestingUtil.killServers(this.hotrodServers);
        this.hotrodServers = null;
    }

    protected void runTest(int size, int possibilities, String name) {
        long currentTime;
        AssertJUnit.assertTrue((possibilities > size ? 1 : 0) != 0);
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i = 0; i < size; ++i) {
            map.put(i, i);
        }
        this.remoteCache.putAll(map);
        long begin = System.currentTimeMillis();
        int iterations = 0;
        HashSet<Integer> set = new HashSet<Integer>();
        Random random = new Random();
        while (this.millisecondsToRun + begin > (currentTime = System.currentTimeMillis())) {
            int count = 0;
            set.clear();
            int i = 0;
            while (i < size) {
                int value = random.nextInt(possibilities);
                if (!set.add(value)) continue;
                ++i;
                if (value >= size) continue;
                ++count;
            }
            AssertJUnit.assertEquals((int)count, (int)this.remoteCache.getAll(set).size());
            ++iterations;
        }
        long totalTime = currentTime - begin;
        System.out.println(name + " - Performed " + iterations + " in " + totalTime + " ms generating " + (long)iterations / (totalTime / 1000L) + " ops/sec");
    }

    public void test5Input() {
        this.runTest(5, 8, "test5Input");
    }

    public void test500Input() {
        this.runTest(500, 800, "test500Input");
    }

    public void test50000Input() {
        this.runTest(50000, 80000, "test50000Input");
    }
}

