/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.stress;

import java.io.IOException;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commons.test.TestResourceTracker;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"stress"}, testName="org.infinispan.client.hotrod.stress.RemoteClientPutGetTest", timeOut=900000L)
public class RemoteClientPutGetTest {
    private RemoteCache<String, Object> cache;
    private static final int NUMBER_OF_ENTRIES = 100000;
    private static final int THREAD_COUNT = 10;
    private static final int GET_OPERATIONS = 100000;

    public static void main(String[] args) throws Exception {
        RemoteClientPutGetTest testCase = new RemoteClientPutGetTest();
        testCase.prepare();
        testCase.putTest();
        testCase.getTest();
    }

    @BeforeClass
    public void prepare() {
        TestResourceTracker.testStarted((String)RemoteClientPutGetTest.class.getName());
        RemoteCacheManager cacheManager = new RemoteCacheManager(HotRodClientTestingUtil.newRemoteConfigurationBuilder().addServer().host("localhost").port(11222).build());
        this.cache = cacheManager.getCache();
        this.cache.clear();
    }

    @AfterClass(alwaysRun=true)
    public void afterClass() throws IOException {
        this.cache.getRemoteCacheManager().close();
    }

    public void putTest() throws Exception {
        int i;
        Thread[] threads = new Thread[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            int thread_index = i2;
            threads[i2] = new Thread(() -> {
                for (int j = 0; j < 100000; ++j) {
                    this.cache.put((Object)("key_" + thread_index + "_" + j), (Object)UUID.randomUUID().toString());
                    if (j % 2 != 0) continue;
                    this.cache.remove((Object)("key_" + thread_index + "_" + j / 2));
                }
            });
        }
        long start = System.nanoTime();
        for (i = 0; i < 10; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            threads[i].join();
        }
        long elapsed = System.nanoTime() - start;
        System.out.format("Puts took: %,d s", TimeUnit.NANOSECONDS.toSeconds(elapsed));
    }

    public void getTest() throws Exception {
        int i;
        Thread[] threads = new Thread[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            int thread_index = i2;
            threads[i2] = new Thread(() -> {
                Random r = new Random(thread_index);
                for (int j = 0; j < 100000; ++j) {
                    int key_id = r.nextInt(100000);
                    this.cache.get((Object)("key_" + thread_index + "_" + key_id));
                }
            });
        }
        long start = System.nanoTime();
        for (i = 0; i < 10; ++i) {
            threads[i].start();
        }
        for (i = 0; i < 10; ++i) {
            threads[i].join();
        }
        long elapsed = System.nanoTime() - start;
        System.out.format("\nGets took: %,d s", TimeUnit.NANOSECONDS.toSeconds(elapsed));
    }
}

