/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tx;

import java.lang.reflect.Method;
import javax.transaction.TransactionManager;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.exceptions.CacheNotTransactionalException;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.tx.InvalidServerConfigTxTest")
public class InvalidServerConfigTxTest
extends SingleHotRodServerTest {
    public void testNonTxCache(Method method) {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(false);
        this.cacheManager.defineConfiguration(method.getName(), builder.build());
        AssertJUnit.assertFalse((boolean)this.remoteCacheManager.isTransactional(method.getName()));
        Exceptions.expectException(CacheNotTransactionalException.class, (String)"ISPN004084.*", () -> this.remoteCacheManager.getCache(method.getName(), TransactionMode.NON_XA));
        RemoteCache cache = this.remoteCacheManager.getCache(method.getName(), TransactionMode.NONE);
        AssertJUnit.assertFalse((boolean)cache.isTransactional());
    }

    public void testReadCommitted(Method method) {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        this.cacheManager.defineConfiguration(method.getName(), builder.build());
        AssertJUnit.assertFalse((boolean)this.remoteCacheManager.isTransactional(method.getName()));
        Exceptions.expectException(CacheNotTransactionalException.class, (String)"ISPN004084.*", () -> this.remoteCacheManager.getCache(method.getName(), TransactionMode.NON_XA));
        RemoteCache cache = this.remoteCacheManager.getCache(method.getName(), TransactionMode.NONE);
        AssertJUnit.assertFalse((boolean)cache.isTransactional());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOkConfig(Method method) throws Exception {
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.cacheManager.defineConfiguration(method.getName(), builder.build());
        AssertJUnit.assertTrue((boolean)this.remoteCacheManager.isTransactional(method.getName()));
        RemoteCache cache = this.remoteCacheManager.getCache(method.getName(), TransactionMode.NON_XA);
        AssertJUnit.assertTrue((boolean)cache.isTransactional());
        TransactionManager tm = cache.getTransactionManager();
        tm.begin();
        try {
            cache.put((Object)"k1", (Object)"v1");
        }
        finally {
            tm.commit();
        }
        AssertJUnit.assertEquals((String)"v1", (String)((String)cache.get((Object)"k1")));
        HotRodClientTestingUtil.assertNoTransaction(this.remoteCacheManager);
    }
}

