/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.tx;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.client.hotrod.transaction.lookup.RemoteTransactionManagerLookup;
import org.infinispan.client.hotrod.tx.util.KeyValueGenerator;
import org.infinispan.commons.tx.TransactionImpl;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.tx.LCROTest")
public class LCROTest
extends MultiHotRodServersTest {
    private static final String CACHE_A = "lrco-a";
    private static final String CACHE_B = "lrco-b";
    private static final String CACHE_C = "lrco-c";
    private static final KeyValueGenerator<String, String> GENERATOR = KeyValueGenerator.STRING_GENERATOR;

    public void testFailureInA(Method method) throws Exception {
        this.doSingleTestFailure(method, CACHE_A);
    }

    public void testFailureInB(Method method) throws Exception {
        this.doSingleTestFailure(method, CACHE_B);
    }

    public void testFailureInC(Method method) throws Exception {
        this.doSingleTestFailure(method, CACHE_C);
    }

    public void testReadOnlyWithWriteInA(Method method) throws Exception {
        this.doReadOnlyWithSingleWriteTest(method, CACHE_A, false);
    }

    public void testReadOnlyWithFailedWriteInA(Method method) throws Exception {
        this.doReadOnlyWithSingleWriteTest(method, CACHE_A, true);
    }

    public void testReadOnlyWithWriteInB(Method method) throws Exception {
        this.doReadOnlyWithSingleWriteTest(method, CACHE_B, false);
    }

    public void testReadOnlyWithFailedWriteInB(Method method) throws Exception {
        this.doReadOnlyWithSingleWriteTest(method, CACHE_B, true);
    }

    public void testReadOnlyWithWriteInC(Method method) throws Exception {
        this.doReadOnlyWithSingleWriteTest(method, CACHE_C, false);
    }

    public void testReadOnlyWithFailedWriteInC(Method method) throws Exception {
        this.doReadOnlyWithSingleWriteTest(method, CACHE_C, true);
    }

    public void testReadOnly(Method method) throws Exception {
        String key = GENERATOR.generateKey(method, 0);
        String value1 = GENERATOR.generateValue(method, 0);
        RemoteCache cacheA = this.client(0).getCache(CACHE_A);
        RemoteCache cacheB = this.client(0).getCache(CACHE_B);
        RemoteCache cacheC = this.client(0).getCache(CACHE_C);
        cacheA.put((Object)key, (Object)value1);
        cacheB.put((Object)key, (Object)value1);
        cacheC.put((Object)key, (Object)value1);
        TransactionManager tm = cacheA.getTransactionManager();
        tm.begin();
        GENERATOR.assertValueEquals(value1, (String)cacheA.get((Object)key));
        GENERATOR.assertValueEquals(value1, (String)cacheB.get((Object)key));
        GENERATOR.assertValueEquals(value1, (String)cacheC.get((Object)key));
        TransactionImpl tx = (TransactionImpl)tm.suspend();
        XAResource resource = this.extractXaResource(tx);
        resource.commit((Xid)tx.getXid(), true);
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cacheBuilder = LCROTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        cacheBuilder.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
        cacheBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        cacheBuilder.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        this.createHotRodServers(3, new org.infinispan.configuration.cache.ConfigurationBuilder());
        this.defineInAll(CACHE_A, cacheBuilder);
        this.defineInAll(CACHE_B, cacheBuilder);
        this.defineInAll(CACHE_C, cacheBuilder);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder clientBuilder = super.createHotRodClientConfigurationBuilder(host, serverPort);
        clientBuilder.forceReturnValues(true);
        for (String cacheName : Arrays.asList(CACHE_A, CACHE_B, CACHE_C)) {
            clientBuilder.remoteCache(cacheName).transactionManagerLookup(RemoteTransactionManagerLookup.getInstance()).transactionMode(TransactionMode.NON_DURABLE_XA);
        }
        return clientBuilder;
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        HotRodClientTestingUtil.assertNoTransaction(this.clients);
        super.clearContent();
    }

    private void doSingleTestFailure(Method method, String conflictCacheName) throws Exception {
        String key = GENERATOR.generateKey(method, 0);
        String value1 = GENERATOR.generateValue(method, 0);
        String value2 = GENERATOR.generateValue(method, 1);
        RemoteCache cacheA = this.client(0).getCache(CACHE_A);
        RemoteCache cacheB = this.client(0).getCache(CACHE_B);
        RemoteCache cacheC = this.client(0).getCache(CACHE_C);
        TransactionManager tm = cacheA.getTransactionManager();
        tm.begin();
        cacheA.put((Object)key, (Object)value1);
        cacheB.put((Object)key, (Object)value1);
        cacheC.put((Object)key, (Object)value1);
        TransactionImpl tx = (TransactionImpl)tm.suspend();
        this.client(0).getCache(conflictCacheName).put((Object)key, (Object)value2);
        XAResource resource = this.extractXaResource(tx);
        try {
            resource.commit((Xid)tx.getXid(), true);
            AssertJUnit.fail((String)"Rollback is expected");
        }
        catch (XAException e) {
            AssertJUnit.assertEquals((int)100, (int)e.errorCode);
        }
        GENERATOR.assertValueEquals(CACHE_A.equals(conflictCacheName) ? value2 : null, (String)cacheA.get((Object)key));
        GENERATOR.assertValueEquals(CACHE_B.equals(conflictCacheName) ? value2 : null, (String)cacheB.get((Object)key));
        GENERATOR.assertValueEquals(CACHE_C.equals(conflictCacheName) ? value2 : null, (String)cacheC.get((Object)key));
    }

    private void doReadOnlyWithSingleWriteTest(Method method, String writeCache, boolean rollback) throws Exception {
        String key = GENERATOR.generateKey(method, 0);
        String value1 = GENERATOR.generateValue(method, 0);
        String value2 = GENERATOR.generateValue(method, 1);
        String value3 = GENERATOR.generateValue(method, 2);
        RemoteCache cacheA = this.client(0).getCache(CACHE_A);
        RemoteCache cacheB = this.client(0).getCache(CACHE_B);
        RemoteCache cacheC = this.client(0).getCache(CACHE_C);
        cacheA.put((Object)key, (Object)value1);
        cacheB.put((Object)key, (Object)value1);
        cacheC.put((Object)key, (Object)value1);
        TransactionManager tm = cacheA.getTransactionManager();
        tm.begin();
        GENERATOR.assertValueEquals(value1, (String)cacheA.get((Object)key));
        GENERATOR.assertValueEquals(value1, (String)cacheB.get((Object)key));
        GENERATOR.assertValueEquals(value1, (String)cacheC.get((Object)key));
        this.client(0).getCache(writeCache).put((Object)key, (Object)value2);
        TransactionImpl tx = (TransactionImpl)tm.suspend();
        if (rollback) {
            this.client(0).getCache(writeCache).put((Object)key, (Object)value3);
        }
        XAResource resource = this.extractXaResource(tx);
        try {
            resource.commit((Xid)tx.getXid(), true);
            AssertJUnit.assertFalse((boolean)rollback);
        }
        catch (XAException e) {
            AssertJUnit.assertTrue((boolean)rollback);
            AssertJUnit.assertEquals((int)100, (int)e.errorCode);
        }
        GENERATOR.assertValueEquals(CACHE_A.equals(writeCache) ? (rollback ? value3 : value2) : value1, (String)cacheA.get((Object)key));
        GENERATOR.assertValueEquals(CACHE_B.equals(writeCache) ? (rollback ? value3 : value2) : value1, (String)cacheB.get((Object)key));
        GENERATOR.assertValueEquals(CACHE_C.equals(writeCache) ? (rollback ? value3 : value2) : value1, (String)cacheC.get((Object)key));
    }

    private XAResource extractXaResource(TransactionImpl tx) {
        Collection resources = tx.getEnlistedResources();
        AssertJUnit.assertEquals((int)1, (int)resources.size());
        return (XAResource)resources.iterator().next();
    }
}

