/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.xsite;

import java.util.Optional;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.xsite.AbstractHotRodSiteFailoverTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.xsite.SiteDownFailoverTest")
public class SiteDownFailoverTest
extends AbstractHotRodSiteFailoverTest {
    private RemoteCacheManager clientA;
    private RemoteCacheManager clientB;

    public void testFailoverAfterSiteShutdown() {
        this.clientA = this.client(SITE_A, Optional.of(SITE_B));
        this.clientB = this.client(SITE_B, Optional.empty());
        RemoteCache cacheA = this.clientA.getCache();
        RemoteCache cacheB = this.clientB.getCache();
        AssertJUnit.assertNull((Object)cacheA.put((Object)1, (Object)"v1"));
        AssertJUnit.assertEquals((String)"v1", (String)((String)cacheA.get((Object)1)));
        AssertJUnit.assertEquals((String)"v1", (String)((String)cacheB.get((Object)1)));
        int portServerSiteA = this.findServerPort(SITE_A);
        this.killSite(SITE_A);
        AssertJUnit.assertEquals((String)"v1", (String)((String)cacheB.get((Object)1)));
        AssertJUnit.assertEquals((String)"v1", (String)((String)cacheA.get((Object)1)));
        this.createHotRodSite(SITE_A, SITE_B, Optional.of(portServerSiteA));
        this.killSite(SITE_B);
        AssertJUnit.assertNull((Object)cacheA.get((Object)1));
        AssertJUnit.assertNull((Object)cacheA.put((Object)2, (Object)"v2"));
        AssertJUnit.assertEquals((String)"v2", (String)((String)cacheA.get((Object)2)));
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        HotRodClientTestingUtil.killRemoteCacheManagers(this.clientA, this.clientB);
        super.destroy();
    }
}

