/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.Collections;
import java.util.Map;
import org.infinispan.client.hotrod.AuthenticationTest;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.core.security.simple.SimpleServerAuthenticationProvider;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractAuthenticationTest
extends SingleCacheManagerTest {
    private static final Log log = LogFactory.getLog(AuthenticationTest.class);
    protected RemoteCacheManager remoteCacheManager;
    protected HotRodServer hotrodServer;

    protected abstract EmbeddedCacheManager createCacheManager() throws Exception;

    protected abstract SimpleServerAuthenticationProvider createAuthenticationProvider();

    protected ConfigurationBuilder initServerAndClient() {
        return this.initServerAndClient(Collections.emptyMap());
    }

    ConfigurationBuilder initServerAndClient(Map<String, String> mechProperties) {
        HotRodServerConfigurationBuilder serverBuilder = HotRodTestingUtil.getDefaultHotRodConfiguration();
        serverBuilder.authentication().enable().serverName("localhost").addAllowedMech("CRAM-MD5").serverAuthenticationProvider((ServerAuthenticationProvider)this.createAuthenticationProvider());
        serverBuilder.authentication().mechProperties(mechProperties);
        this.hotrodServer = HotRodTestingUtil.startHotRodServer((EmbeddedCacheManager)this.cacheManager, (HotRodServerConfigurationBuilder)serverBuilder);
        log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotrodServer.getPort().intValue()).socketTimeout(3000).maxRetries(3).connectionPool().maxActive(1).security().authentication().enable().saslMechanism("CRAM-MD5").connectionPool().maxActive(1);
        return clientBuilder;
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        this.remoteCacheManager = null;
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        this.hotrodServer = null;
        super.teardown();
    }
}

