/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.DefaultExpirationTest", groups={"functional"})
public class DefaultExpirationTest
extends SingleCacheManagerTest {
    protected RemoteCache<String, String> remoteCache;
    protected RemoteCacheManager remoteCacheManager;
    protected HotRodServer hotrodServer;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((org.infinispan.configuration.cache.ConfigurationBuilder)this.getDefaultStandaloneCacheConfig(false));
        builder.expiration().lifespan(3L, TimeUnit.SECONDS).maxIdle(2L, TimeUnit.SECONDS);
        return TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        log.info((Object)("Started server on port: " + this.hotrodServer.getPort()));
        this.remoteCacheManager = this.getRemoteCacheManager();
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    protected RemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        return new RemoteCacheManager(clientBuilder.build());
    }

    @AfterClass
    public void testDestroyRemoteCacheFactory() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        this.hotrodServer = null;
    }

    @Test
    public void testDefaultExpiration() throws Exception {
        this.remoteCache.put((Object)"Key", (Object)"Value");
        AdvancedCache embeddedCache = this.cacheManager.getCache().getAdvancedCache();
        InternalCacheEntry entry = (InternalCacheEntry)embeddedCache.getCacheEntry((Object)"Key");
        AssertJUnit.assertEquals((Object)"Value", (Object)entry.getValue());
        AssertJUnit.assertTrue((boolean)entry.canExpire());
        AssertJUnit.assertEquals((long)3000L, (long)entry.getLifespan());
        AssertJUnit.assertEquals((long)2000L, (long)entry.getMaxIdle());
        Thread.sleep(5000L);
        AssertJUnit.assertFalse((boolean)this.remoteCache.containsKey((Object)"Key"));
    }
}

