/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.data.Person;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.EventWithStorageTypeTest")
public class EventWithStorageTypeTest
extends SingleHotRodServerTest {
    private StorageType storageType;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().storageType(this.storageType);
        return TestCacheManagerFactory.createCacheManager((SerializationContextInitializer)this.contextInitializer(), (ConfigurationBuilder)builder);
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new EventWithStorageTypeTest().storageType(StorageType.OBJECT), new EventWithStorageTypeTest().storageType(StorageType.BINARY), new EventWithStorageTypeTest().storageType(StorageType.OFF_HEAP)};
    }

    private Object storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return TestDataSCI.INSTANCE;
    }

    protected String parameters() {
        return "storageType-" + this.storageType;
    }

    @Test
    public void testReceiveKeyValues() throws InterruptedException {
        RemoteCache cache = this.remoteCacheManager.getCache();
        EventListener listener = new EventListener();
        cache.addClientListener((Object)listener);
        cache.put((Object)"1", (Object)new Person("John"));
        Object key = listener.getEventKey();
        AssertJUnit.assertNotNull((Object)key);
        AssertJUnit.assertEquals((Object)"1", (Object)key);
    }

    @ClientListener
    static class EventListener {
        private final BlockingQueue<String> eventsQueue = new LinkedBlockingQueue<String>();

        EventListener() {
        }

        Object getEventKey() throws InterruptedException {
            return this.eventsQueue.poll(5L, TimeUnit.SECONDS);
        }

        @ClientCacheEntryCreated
        public void handleCreatedEvent(ClientCacheEntryCreatedEvent<String> event) {
            this.eventsQueue.add((String)event.getKey());
        }

        @ClientCacheEntryModified
        public void handleModifiedEvent(ClientCacheEntryModifiedEvent<String> event) {
            this.eventsQueue.add((String)event.getKey());
        }
    }
}

