/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.event;

import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.event.EventLogListener;
import org.infinispan.client.hotrod.query.RemoteQueryTestUtils;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.event.JsonEventsTest")
public class JsonEventsTest
extends SingleHotRodServerTest {
    @Override
    protected void setup() throws Exception {
        super.setup();
        RemoteCache schemaCache = this.remoteCacheManager.getCache("___protobuf_metadata");
        schemaCache.put((Object)"schema.proto", (Object)"message A { optional string key = 1; }");
        RemoteQueryTestUtils.checkSchemaErrors((BasicCache<String, String>)schemaCache);
    }

    public void testCreatedEvent() {
        DataFormat jsonValues = DataFormat.builder().valueType(MediaType.APPLICATION_JSON).valueMarshaller((Marshaller)new UTF8StringMarshaller()).build();
        EventLogListener l = new EventLogListener(this.remoteCacheManager.getCache().withDataFormat(jsonValues));
        HotRodClientTestingUtil.withClientListener(l, remote -> {
            l.expectNoEvents();
            remote.put((Object)1, (Object)"{\"_type\":\"A\",\"key\":\"one\"}");
            l.expectOnlyCreatedEvent(1);
            remote.put((Object)2, (Object)"{\"_type\":\"A\",\"key\":\"two\"}");
            l.expectOnlyCreatedEvent(2);
        });
    }
}

