/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.marshall;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.MarshallerRegistry;
import org.infinispan.client.hotrod.marshall.CtxInitializerImpl;
import org.infinispan.client.hotrod.test.SingleHotRodServerTest;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.infinispan.commons.marshall.IdentityMarshaller;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

@Test(groups={"functional"}, testName="client.hotrod.MarshallerPerCacheTest")
public class MarshallerPerCacheTest
extends SingleHotRodServerTest {
    private static final String CACHE_TEXT = "text";
    private static final String CACHE_JAVA_SERIALIZED = "serialized";
    private static final String CACHE_DEFAULT = "default";
    private static final Object KEY = 1;
    private static final Object VALUE = new CustomValue("this is the value");

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().nonClusteredDefault();
        ((PrivateGlobalConfigurationBuilder)gcb.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)gcb, (org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        Configuration protobufConfig = new org.infinispan.configuration.cache.ConfigurationBuilder().encoding().mediaType("application/x-protostream").build();
        Configuration defaultConfig = new org.infinispan.configuration.cache.ConfigurationBuilder().build();
        cm.createCache(CACHE_TEXT, defaultConfig);
        cm.createCache(CACHE_JAVA_SERIALIZED, defaultConfig);
        cm.createCache(CACHE_DEFAULT, protobufConfig);
        return cm;
    }

    @Override
    protected SerializationContextInitializer contextInitializer() {
        return CtxInitializer.INSTANCE;
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(String host, int serverPort) {
        ConfigurationBuilder builder = super.createHotRodClientConfigurationBuilder(host, serverPort);
        builder.security().addJavaSerialAllowList(new String[]{".*CustomValue.*"});
        builder.remoteCache(CACHE_DEFAULT).marshaller(ProtoStreamMarshaller.class);
        builder.remoteCache(CACHE_TEXT).marshaller((Marshaller)new CustomValueMarshaller());
        builder.remoteCache(CACHE_JAVA_SERIALIZED).marshaller(JavaSerializationMarshaller.class);
        return builder;
    }

    @Test
    public void testMarshallerPerCache() throws IOException, InterruptedException {
        MarshallerRegistry marshallerRegistry = this.remoteCacheManager.getMarshallerRegistry();
        this.assertMarshallerUsed(CACHE_DEFAULT, marshallerRegistry.getMarshaller(MediaType.APPLICATION_PROTOSTREAM));
        this.assertMarshallerUsed(CACHE_TEXT, (Marshaller)new CustomValueMarshaller());
        this.assertMarshallerUsed(CACHE_JAVA_SERIALIZED, marshallerRegistry.getMarshaller(MediaType.APPLICATION_SERIALIZED_OBJECT));
    }

    @Test
    public void testOverrideMarshallerAtRuntime() throws Exception {
        RemoteCache cache = this.remoteCacheManager.getCache(CACHE_JAVA_SERIALIZED);
        cache.put((Object)"KEY", VALUE);
        RemoteCache rawValueCache = cache.withDataFormat(DataFormat.builder().valueMarshaller((Marshaller)IdentityMarshaller.INSTANCE).build());
        byte[] rawValue = (byte[])rawValueCache.get((Object)"KEY");
        ArrayAsserts.assertArrayEquals((byte[])new JavaSerializationMarshaller().objectToByteBuffer(VALUE), (byte[])rawValue);
    }

    private void assertMarshallerUsed(String cacheName, Marshaller expectedMarshaller) throws InterruptedException, IOException {
        RemoteCache remoteCache = this.remoteCacheManager.getCache(cacheName);
        remoteCache.put(KEY, VALUE);
        AssertJUnit.assertEquals((Object)VALUE, (Object)remoteCache.get(KEY));
        Cache cache = this.cacheManager.getCache(remoteCache.getName());
        AdvancedCache asStored = cache.getAdvancedCache().withStorageMediaType();
        byte[] keyMarshalled = expectedMarshaller.objectToByteBuffer(KEY);
        byte[] valueMarshalled = expectedMarshaller.objectToByteBuffer(VALUE);
        ArrayAsserts.assertArrayEquals((byte[])valueMarshalled, (byte[])((byte[])asStored.get((Object)keyMarshalled)));
    }

    static final class CustomValueMarshaller
    extends AbstractMarshaller {
        CustomValueMarshaller() {
        }

        protected ByteBuffer objectToBuffer(Object o, int estimatedSize) {
            String json;
            if (o instanceof CustomValue) {
                CustomValue customValue = (CustomValue)o;
                json = Json.object().set("field", (Object)customValue.getField()).toString();
            } else {
                json = Json.make((Object)o).asString();
            }
            return ByteBufferImpl.create((byte[])json.getBytes(StandardCharsets.UTF_8));
        }

        public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
            Json json = Json.read((String)new String(buf, StandardCharsets.UTF_8));
            if (json.has("field")) {
                return new CustomValue(json.at("field").asString());
            }
            return json.asString();
        }

        public boolean isMarshallable(Object o) {
            return o instanceof CustomValue || o instanceof String;
        }

        public MediaType mediaType() {
            return MediaType.APPLICATION_JSON;
        }
    }

    static class CustomValue
    implements Serializable {
        private String field;

        @ProtoFactory
        public CustomValue(String field) {
            this.field = field;
        }

        @ProtoField(value=1)
        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CustomValue that = (CustomValue)o;
            return this.field.equals(that.field);
        }

        public int hashCode() {
            return Objects.hash(this.field);
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={CustomValue.class}, schemaFileName="custom-value.proto", schemaFilePath="proto/generated", schemaPackageName="org.infinispan.test.client.MarshallerPerCacheTest")
    static interface CtxInitializer
    extends SerializationContextInitializer {
        public static final CtxInitializer INSTANCE = new CtxInitializerImpl();
    }
}

