/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.client.hotrod.query.News;
import org.infinispan.client.hotrod.query.NewsKey;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.query.MultiServerStoreQueryTest", groups={"functional"})
public class MultiServerStoreQueryTest
extends MultiHotRodServersTest {
    private static final int NODES = 2;
    private static final boolean USE_PERSISTENCE = true;
    private static final String USER_CACHE = "news";
    private RemoteCache<Object, Object> userCache;
    private long evictionSize = -1L;

    protected String parameters() {
        return "[" + this.storageType + ":" + this.evictionSize + "]";
    }

    protected String[] parameterNames() {
        return (String[])MultiServerStoreQueryTest.concat((Object[])super.parameterNames(), (Object[])new String[]{"STORAGE-TYPE", "EVICTION_SIZE"});
    }

    protected Object[] parameterValues() {
        return MultiServerStoreQueryTest.concat((Object[])super.parameterValues(), (Object[])new Object[]{this.storageType, this.evictionSize});
    }

    public Object[] factory() {
        return new Object[]{new MultiServerStoreQueryTest().storageType(StorageType.OFF_HEAP), new MultiServerStoreQueryTest().storageType(StorageType.BINARY), new MultiServerStoreQueryTest().storageType(StorageType.OBJECT), new MultiServerStoreQueryTest().storageType(StorageType.OFF_HEAP).evictionSize(1L), new MultiServerStoreQueryTest().storageType(StorageType.BINARY).evictionSize(1L), new MultiServerStoreQueryTest().storageType(StorageType.OBJECT).evictionSize(1L)};
    }

    public MultiServerStoreQueryTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    MultiServerStoreQueryTest evictionSize(long size) {
        this.evictionSize = size;
        return this;
    }

    public Configuration getLockCacheConfig() {
        return MultiServerStoreQueryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false).build();
    }

    public Configuration getLuceneCacheConfig(String storeName) {
        ConfigurationBuilder builder = MultiServerStoreQueryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true)).storeName(storeName);
        return builder.build();
    }

    public Configuration buildIndexedConfig(String storeName) {
        ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration((ConfigurationBuilder)MultiServerStoreQueryTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false));
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).writer().commitInterval(500).ramBufferSize(256).merge().factor(30).maxSize(1024).addIndexedEntity("News");
        builder.memory().storageType(this.storageType);
        if (this.evictionSize > 0L) {
            builder.memory().size(this.evictionSize);
        }
        ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).preload(true)).storeName(storeName);
        return builder.build();
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder defaultConfiguration = new ConfigurationBuilder();
        this.createHotRodServers(2, defaultConfiguration);
        RemoteCacheManager remoteCacheManager = this.client(0);
        SerializationContext serializationContext = MarshallerUtil.getSerializationContext((RemoteCacheManager)remoteCacheManager);
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String protoFile = protoSchemaBuilder.fileName("news.proto").addClass(News.class).addClass(NewsKey.class).build(serializationContext);
        RemoteCache metadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        metadataCache.put((Object)"news.proto", (Object)protoFile);
        AssertJUnit.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        for (int i = 0; i < this.cacheManagers.size(); ++i) {
            EmbeddedCacheManager cm = (EmbeddedCacheManager)this.cacheManagers.get(i);
            cm.defineConfiguration(USER_CACHE, this.buildIndexedConfig("News-" + i));
            cm.getCache(USER_CACHE);
        }
        this.waitForClusterToForm(USER_CACHE);
        this.userCache = remoteCacheManager.getCache(USER_CACHE);
    }

    public void testIndexing() {
        News news = new News();
        news.setId("testnews");
        news.setTimestamp(0L);
        this.userCache.put((Object)news.getId(), (Object)news);
        Object testNews = this.userCache.get((Object)"testnews");
        AssertJUnit.assertEquals((Object)news, (Object)testNews);
    }

    public void testNonPrimitiveKey() {
        NewsKey newsKey1 = new NewsKey();
        newsKey1.setArticle("articleKey1");
        NewsKey newsKey2 = new NewsKey();
        newsKey2.setArticle("articleKey2");
        News news1 = new News();
        news1.setId("test-news-1");
        news1.setTimestamp(0L);
        News news2 = new News();
        news2.setId("test-news-2");
        news2.setTimestamp(0L);
        this.userCache.put((Object)newsKey1, (Object)news1);
        this.userCache.put((Object)newsKey2, (Object)news2);
        AssertJUnit.assertEquals((Object)news1, (Object)this.userCache.get((Object)newsKey1));
        AssertJUnit.assertEquals((Object)news2, (Object)this.userCache.get((Object)newsKey2));
    }
}

