/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.query;

import java.time.Instant;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.marshall.NotIndexedSCI;
import org.infinispan.client.hotrod.query.testdomain.protobuf.AnalyzerTestEntity;
import org.infinispan.client.hotrod.query.testdomain.protobuf.ModelFactoryPB;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.AnalyzerTestEntityMarshaller;
import org.infinispan.client.hotrod.query.testdomain.protobuf.marshallers.TestDomainSCI;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.configuration.cache.IndexStorage;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.marshall.AbstractSerializationContextInitializer;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.embedded.QueryStringTest;
import org.infinispan.query.dsl.embedded.testdomain.ModelFactory;
import org.infinispan.query.dsl.embedded.testdomain.NotIndexed;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.query.RemoteQueryStringTest")
public class RemoteQueryStringTest
extends QueryStringTest {
    private static final SerializationContextInitializer CUSTOM_ANALYZER_SCI = new AbstractSerializationContextInitializer("custom_analyzer.proto"){

        public String getProtoFile() {
            return "package sample_bank_account;\n/* @Indexed \n   @Analyzer(definition = \"standard-with-stop\") */message AnalyzerTestEntity {\n\t/* @Field(store = Store.YES, analyze = Analyze.YES, analyzer = @Analyzer(definition = \"stemmer\")) */\n\toptional string f1 = 1;\n\t/* @Field(store = Store.YES, analyze = Analyze.NO, indexNullAs = \"-1\") */\n\toptional int32 f2 = 2;\n}\n";
        }

        public void registerMarshallers(SerializationContext serCtx) {
            serCtx.registerMarshaller((BaseMarshaller)new AnalyzerTestEntityMarshaller());
        }
    };
    protected HotRodServer hotRodServer;
    protected RemoteCacheManager remoteCacheManager;
    protected RemoteCache<Object, Object> remoteCache;
    protected Cache<Object, Object> cache;

    @BeforeClass
    protected void populateCache() throws Exception {
        super.populateCache();
        this.getCacheForWrite().put((Object)"analyzed1", (Object)new AnalyzerTestEntity("tested 123", 3));
        this.getCacheForWrite().put((Object)"analyzed2", (Object)new AnalyzerTestEntity("testing 1234", 3));
        this.getCacheForWrite().put((Object)"analyzed3", (Object)new AnalyzerTestEntity("xyz", null));
    }

    protected QueryFactory getQueryFactory() {
        return Search.getQueryFactory(this.remoteCache);
    }

    protected ModelFactory getModelFactory() {
        return ModelFactoryPB.INSTANCE;
    }

    protected RemoteCache<Object, Object> getCacheForQuery() {
        return this.remoteCache;
    }

    protected Cache<Object, Object> getEmbeddedCache() {
        return this.cache;
    }

    protected int getNodesCount() {
        return 1;
    }

    protected void createCacheManagers() throws Throwable {
        GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().clusteredDefault();
        globalBuilder.serialization().addContextInitializers(new SerializationContextInitializer[]{TestDomainSCI.INSTANCE, NotIndexedSCI.INSTANCE, CUSTOM_ANALYZER_SCI});
        this.createClusteredCaches(this.getNodesCount(), globalBuilder, this.getConfigurationBuilder(), true, new String[0]);
        this.cache = this.manager(0).getCache();
        this.hotRodServer = HotRodClientTestingUtil.startHotRodServer(this.manager(0));
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("127.0.0.1").port(this.hotRodServer.getPort().intValue()).addContextInitializers(new SerializationContextInitializer[]{TestDomainSCI.INSTANCE, NotIndexedSCI.INSTANCE, CUSTOM_ANALYZER_SCI});
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        this.remoteCache = this.remoteCacheManager.getCache();
    }

    protected org.infinispan.configuration.cache.ConfigurationBuilder getConfigurationBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.indexing().enable().storage(IndexStorage.LOCAL_HEAP).addIndexedEntity("sample_bank_account.User").addIndexedEntity("sample_bank_account.Account").addIndexedEntity("sample_bank_account.Transaction").addIndexedEntity("sample_bank_account.AnalyzerTestEntity");
        return builder;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        HotRodClientTestingUtil.killRemoteCacheManager(this.remoteCacheManager);
        this.remoteCacheManager = null;
        HotRodClientTestingUtil.killServers(this.hotRodServer);
        this.hotRodServer = null;
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN014036: Prefix, wildcard or regexp queries cannot be fuzzy.*")
    public void testFullTextWildcardFuzzyNotAllowed() {
        super.testFullTextWildcardFuzzyNotAllowed();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN028526: Invalid query.*")
    public void testFullTextRegexpFuzzyNotAllowed() {
        super.testFullTextRegexpFuzzyNotAllowed();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN028522: .*property is analyzed.*")
    public void testExactMatchOnAnalyzedFieldNotAllowed() {
        super.testExactMatchOnAnalyzedFieldNotAllowed();
    }

    @Test(expectedExceptions={HotRodClientException.class}, expectedExceptionsMessageRegExp="org.infinispan.objectfilter.ParsingException: ISPN028521: .*unless the property is indexed and analyzed.*")
    public void testFullTextTermOnNonAnalyzedFieldNotAllowed() {
        super.testFullTextTermOnNonAnalyzedFieldNotAllowed();
    }

    public void testInstant1() {
        Query q = this.createQueryFromString("from " + this.getModelFactory().getUserTypeName() + " u where u.creationDate = " + Instant.parse("2011-12-03T10:15:30Z").toEpochMilli());
        List list = q.execute().list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testInstant2() {
        Query q = this.createQueryFromString("from " + this.getModelFactory().getUserTypeName() + " u where u.passwordExpirationDate = " + Instant.parse("2011-12-03T10:15:30Z").toEpochMilli());
        List list = q.execute().list();
        AssertJUnit.assertEquals((int)3, (int)list.size());
    }

    public void testCustomFieldAnalyzer() {
        Query q = this.createQueryFromString("from sample_bank_account.AnalyzerTestEntity where f1:'test'");
        List list = q.execute().list();
        AssertJUnit.assertEquals((int)2, (int)list.size());
    }

    public void testEqNonIndexedType() {
        Query q = this.createQueryFromString("from sample_bank_account.NotIndexed where notIndexedField = 'testing 123'");
        List list = q.execute().list();
        AssertJUnit.assertEquals((int)1, (int)list.size());
        AssertJUnit.assertEquals((String)"testing 123", (String)((NotIndexed)list.get((int)0)).notIndexedField);
    }
}

