/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.CacheContainerTest")
public class CacheContainerTest
extends SingleCacheManagerTest {
    private static final String CACHE_NAME = "someName";
    EmbeddedCacheManager cacheManager = null;
    HotRodServer hotrodServer = null;
    RemoteCacheManager remoteCacheManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.cacheManager.defineConfiguration(CACHE_NAME, HotRodTestingUtil.hotRodCacheConfiguration().build());
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
        return this.cacheManager;
    }

    @AfterClass(alwaysRun=true)
    public void release() {
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{this.cacheManager});
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        this.hotrodServer = null;
    }

    public void testObtainingSameInstanceMultipleTimes() {
        RemoteCache objectCache = this.remoteCacheManager.getCache();
        RemoteCache objectCache2 = this.remoteCacheManager.getCache();
        assert (objectCache == objectCache2);
    }

    public void testObtainingSameInstanceMultipleTimes2() {
        RemoteCache objectCache = this.remoteCacheManager.getCache(CACHE_NAME);
        RemoteCache objectCache2 = this.remoteCacheManager.getCache(CACHE_NAME);
        assert (objectCache == objectCache2);
    }
}

