/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.BaseCustomAsyncInterceptor;
import org.infinispan.interceptors.impl.CallInterceptor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.LockingTest", groups={"functional"})
@CleanupAfterTest
public class LockingTest
extends SingleCacheManagerTest {
    private RemoteCacheManager remoteCacheManager;
    private HotRodServer hotrodServer;

    public void testPerEntryLockContainer() throws Exception {
        this.doLockTest(CacheName.PER_ENTRY_LOCK);
    }

    public void testStrippedLockContainer() throws Exception {
        this.doLockTest(CacheName.STRIPPED_LOCK);
    }

    protected void teardown() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)this.remoteCacheManager);
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        this.hotrodServer = null;
        super.teardown();
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = HotRodTestingUtil.hotRodCacheConfiguration();
        builder.locking().lockAcquisitionTimeout(100L, TimeUnit.MILLISECONDS);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)builder);
        for (CacheName cacheName : CacheName.values()) {
            cacheName.configure(builder);
            cacheManager.defineConfiguration(cacheName.name(), builder.build());
            cacheManager.getCache(cacheName.name());
        }
        return cacheManager;
    }

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue());
        this.remoteCacheManager = new RemoteCacheManager(clientBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLockTest(CacheName cacheName) throws Exception {
        RemoteCache remoteCache = this.remoteCacheManager.getCache(cacheName.name());
        CheckPoint checkPoint = this.injectBlockingCommandInterceptor(cacheName.name());
        Future op = this.fork(() -> {
            remoteCache.put((Object)"key", (Object)"value1");
            return null;
        });
        checkPoint.awaitStrict("before-block", 30L, TimeUnit.SECONDS);
        try {
            for (int i = 0; i < 50; ++i) {
                try {
                    remoteCache.put((Object)"key", (Object)("value" + i));
                    AssertJUnit.fail((String)"It should have fail with lock timeout!");
                    continue;
                }
                catch (Exception e) {
                    log.trace((Object)"Exception caught", (Throwable)e);
                    if (e.getLocalizedMessage().contains("Unable to acquire lock after")) continue;
                    throw e;
                }
            }
        }
        finally {
            checkPoint.trigger("block");
        }
        op.get();
        AssertJUnit.assertEquals((String)"value1", (String)((String)remoteCache.get((Object)"key")));
    }

    private CheckPoint injectBlockingCommandInterceptor(String cacheName) {
        final CheckPoint checkPoint = new CheckPoint();
        TestingUtil.extractInterceptorChain((Cache)this.cache(cacheName)).addInterceptorBefore((AsyncInterceptor)new BaseCustomAsyncInterceptor(){
            private final AtomicBoolean first = new AtomicBoolean(false);

            public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) {
                if (this.first.compareAndSet(false, true)) {
                    checkPoint.trigger("before-block");
                    return this.asyncInvokeNext(ctx, (VisitableCommand)command, checkPoint.future("block", 30L, TimeUnit.SECONDS, (Executor)LockingTest.this.testExecutor()));
                }
                return this.invokeNext(ctx, (VisitableCommand)command);
            }
        }, CallInterceptor.class);
        return checkPoint;
    }

    private static enum CacheName {
        STRIPPED_LOCK{

            @Override
            void configure(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
                builder.locking().useLockStriping(true);
            }
        }
        ,
        PER_ENTRY_LOCK{

            @Override
            void configure(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
                builder.locking().useLockStriping(false);
            }
        };


        abstract void configure(org.infinispan.configuration.cache.ConfigurationBuilder var1);
    }
}

