/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import io.netty.channel.Channel;
import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Queue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheContainer;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.client.hotrod.test.InternalRemoteCacheManager;
import org.infinispan.client.hotrod.test.NoopChannelOperation;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.ServerErrorTest")
public class ServerErrorTest
extends SingleCacheManagerTest {
    private HotRodServer hotrodServer;
    private InternalRemoteCacheManager remoteCacheManager;
    private RemoteCache<String, String> remoteCache;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        this.cacheManager = TestCacheManagerFactory.createCacheManager((org.infinispan.configuration.cache.ConfigurationBuilder)HotRodTestingUtil.hotRodCacheConfiguration());
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
        this.remoteCacheManager = this.getRemoteCacheManager();
        this.remoteCache = this.remoteCacheManager.getCache();
        return this.cacheManager;
    }

    protected InternalRemoteCacheManager getRemoteCacheManager() {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host(this.hotrodServer.getHost()).port(this.hotrodServer.getPort().intValue());
        clientBuilder.connectionPool().maxActive(1).minIdle(1);
        return new InternalRemoteCacheManager(clientBuilder.build());
    }

    @AfterClass
    public void shutDownHotrod() {
        HotRodClientTestingUtil.killRemoteCacheManager((RemoteCacheContainer)this.remoteCacheManager);
        this.remoteCacheManager = null;
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        this.hotrodServer = null;
    }

    public void testErrorWhileDoingPut(Method m) {
        this.cache.getAdvancedCache().withStorageMediaType().addListener((Object)new ErrorInducingListener());
        this.remoteCache = this.remoteCacheManager.getCache();
        this.remoteCache.put((Object)TestingUtil.k((Method)m), (Object)TestingUtil.v((Method)m));
        AssertJUnit.assertEquals((String)TestingUtil.v((Method)m), (String)((String)this.remoteCache.get((Object)TestingUtil.k((Method)m))));
        ChannelFactory channelFactory = this.remoteCacheManager.getChannelFactory();
        InetSocketAddress address = InetSocketAddress.createUnresolved(this.hotrodServer.getHost(), this.hotrodServer.getPort());
        Channel channel = (Channel)((NoopChannelOperation)channelFactory.fetchChannelAndInvoke((SocketAddress)address, (ChannelOperation)new NoopChannelOperation())).join();
        AbstractScheduledEventExecutor scheduledExecutor = (AbstractScheduledEventExecutor)channel.eventLoop();
        Queue scheduledTaskQueue = (Queue)TestingUtil.extractField((Object)scheduledExecutor, (String)"scheduledTaskQueue");
        int scheduledTasksBaseline = scheduledTaskQueue.size();
        channelFactory.releaseChannel(channel);
        AssertJUnit.assertEquals((int)0, (int)channelFactory.getNumActive((SocketAddress)address));
        AssertJUnit.assertEquals((int)1, (int)channelFactory.getNumIdle((SocketAddress)address));
        log.debug((Object)"Sending failing operation to server");
        Exceptions.expectException(HotRodClientException.class, () -> this.remoteCache.put((Object)"FailFailFail", (Object)"whatever..."));
        AssertJUnit.assertEquals((int)0, (int)channelFactory.getNumActive((SocketAddress)address));
        AssertJUnit.assertEquals((int)1, (int)channelFactory.getNumIdle((SocketAddress)address));
        HeaderDecoder headerDecoder = (HeaderDecoder)channel.pipeline().get(HeaderDecoder.class);
        AssertJUnit.assertEquals((int)0, (int)headerDecoder.registeredOperations());
        AssertJUnit.assertEquals((int)scheduledTasksBaseline, (int)scheduledTaskQueue.size());
        log.debug((Object)"Sending new request after server failure");
        this.remoteCache.put((Object)TestingUtil.k((Method)m, (int)2), (Object)TestingUtil.v((Method)m, (int)2));
        AssertJUnit.assertEquals((String)TestingUtil.v((Method)m, (int)2), (String)((String)this.remoteCache.get((Object)TestingUtil.k((Method)m, (int)2))));
    }

    @Listener
    public static class ErrorInducingListener {
        @CacheEntryCreated
        public void entryCreated(CacheEntryEvent<byte[], byte[]> event) throws Exception {
            if (event.isPre() && HotRodTestingUtil.unmarshall((byte[])((byte[])event.getKey())).equals("FailFailFail")) {
                throw new TestException("Simulated server failure");
            }
        }
    }
}

