/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.ServerStatistics;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.test.FixedServerBalancing;
import org.infinispan.client.hotrod.test.MultiHotRodServersTest;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodServer;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="client.hotrod.StorageRoutingTest")
public class StorageRoutingTest
extends MultiHotRodServersTest {
    private static final int CLUSTER_SIZE = 3;
    private Object key;

    public Object[] factory() {
        String stringKey = "key";
        byte[] byteArrayKey = new byte[]{1, 2, 3};
        return new Object[]{new StorageRoutingTest().withStorageType(StorageType.OBJECT).withKey(stringKey), new StorageRoutingTest().withStorageType(StorageType.OBJECT).withKey(byteArrayKey), new StorageRoutingTest().withStorageType(StorageType.OFF_HEAP).withKey(stringKey), new StorageRoutingTest().withStorageType(StorageType.OFF_HEAP).withKey(byteArrayKey), new StorageRoutingTest().withStorageType(StorageType.BINARY).withKey(stringKey), new StorageRoutingTest().withStorageType(StorageType.BINARY).withKey(byteArrayKey)};
    }

    protected String[] parameterNames() {
        return new String[]{null, "key"};
    }

    protected Object[] parameterValues() {
        return new Object[]{this.storageType, this.key.getClass().getSimpleName()};
    }

    private StorageRoutingTest withStorageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    private StorageRoutingTest withKey(Object key) {
        this.key = key;
        return this;
    }

    protected void createCacheManagers() throws Throwable {
        org.infinispan.configuration.cache.ConfigurationBuilder cfgBuilder = StorageRoutingTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        cfgBuilder.jmxStatistics().enable();
        cfgBuilder.clustering().hash().numOwners(1);
        cfgBuilder.memory().storage(this.storageType);
        this.createHotRodServers(3, cfgBuilder);
        this.waitForClusterToForm();
    }

    @Override
    protected void modifyGlobalConfiguration(GlobalConfigurationBuilder builder) {
        super.modifyGlobalConfiguration(builder);
        builder.metrics().accurateSize(true);
    }

    @Override
    protected ConfigurationBuilder createHotRodClientConfigurationBuilder(HotRodServer hotRodServer) {
        ConfigurationBuilder hotRodClientConfigurationBuilder = super.createHotRodClientConfigurationBuilder(hotRodServer);
        hotRodClientConfigurationBuilder.balancingStrategy(() -> new FixedServerBalancing(hotRodServer));
        return hotRodClientConfigurationBuilder;
    }

    @Test
    public void shouldContactKeyOwnerForPutGet() {
        String value = "value";
        RemoteCache remoteCache = ((RemoteCacheManager)this.clients.get(0)).getCache();
        remoteCache.put(this.key, (Object)value);
        Assert.assertEquals((String)((String)remoteCache.get(this.key)), (String)"value");
        this.assertCorrectServerContacted();
    }

    private void assertCorrectServerContacted() {
        AtomicInteger storedIn = new AtomicInteger(-1);
        AtomicInteger retrievedFrom = new AtomicInteger(-1);
        for (int i = 0; i < this.clients.size(); ++i) {
            RemoteCacheManager rcm = this.client(i);
            RemoteCache cache = rcm.getCache();
            ServerStatistics statistics = cache.serverStatistics();
            int retrievals = statistics.getIntStatistic("retrievals");
            int dataContainerSize = statistics.getIntStatistic("currentNumberOfEntries");
            if (retrievals == 1 && !retrievedFrom.compareAndSet(-1, i)) {
                Assert.fail((String)"Retrieval happened in more than 1 server!");
            }
            if (dataContainerSize != 1 || storedIn.compareAndSet(-1, i)) continue;
            Assert.fail((String)"Store happened in more than 1 server!");
        }
        int storeServer = storedIn.get();
        int retrieveServer = retrievedFrom.get();
        Assert.assertTrue((storeServer != -1 ? 1 : 0) != 0, (String)"Entry was not stored!");
        Assert.assertTrue((retrieveServer != -1 ? 1 : 0) != 0, (String)"Entry was not retrieved!");
        Assert.assertEquals((int)storeServer, (int)retrieveServer, (String)String.format("Entry stored on server %d but retrieved from server %d", storeServer, retrieveServer));
    }
}

