/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.TransportFactory;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.impl.transport.netty.DefaultTransportFactory;
import org.infinispan.client.hotrod.test.HotRodClientTestingUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="client.hotrod.TransportFactoryTest", groups={"functional"})
@CleanupAfterTest
public class TransportFactoryTest
extends SingleCacheManagerTest {
    private HotRodServer hotrodServer;

    protected void setup() throws Exception {
        super.setup();
        this.hotrodServer = HotRodClientTestingUtil.startHotRodServer(this.cacheManager);
    }

    protected void teardown() {
        HotRodClientTestingUtil.killServers(this.hotrodServer);
        super.teardown();
    }

    public void testTransportFactoryProgrammatic() {
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        TestTransportFactory transportFactory = new TestTransportFactory();
        clientBuilder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue()).transportFactory((TransportFactory)transportFactory);
        try (RemoteCacheManager remoteCacheManager = new RemoteCacheManager(clientBuilder.build());){
            AssertJUnit.assertEquals((long)0L, (long)transportFactory.socketChannelLatch.getCount());
            AssertJUnit.assertEquals((long)0L, (long)transportFactory.createEventLoopGroupLatch.getCount());
        }
    }

    public void testTransportFactoryDeclarative() {
        Properties p = new Properties();
        p.setProperty("infinispan.client.hotrod.transport_factory", TestTransportFactory.class.getName());
        ConfigurationBuilder clientBuilder = HotRodClientTestingUtil.newRemoteConfigurationBuilder();
        clientBuilder.addServer().host("localhost").port(this.hotrodServer.getPort().intValue()).withProperties(p);
        try (RemoteCacheManager remoteCacheManager = new RemoteCacheManager(clientBuilder.build());){
            Configuration configuration = remoteCacheManager.getConfiguration();
            AssertJUnit.assertTrue((boolean)(configuration.transportFactory() instanceof TestTransportFactory));
            TestTransportFactory transportFactory = (TestTransportFactory)configuration.transportFactory();
            AssertJUnit.assertEquals((long)0L, (long)transportFactory.socketChannelLatch.getCount());
            AssertJUnit.assertEquals((long)0L, (long)transportFactory.createEventLoopGroupLatch.getCount());
        }
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }

    public static class TestTransportFactory
    extends DefaultTransportFactory {
        CountDownLatch socketChannelLatch = new CountDownLatch(1);
        CountDownLatch createEventLoopGroupLatch = new CountDownLatch(1);

        public Class<? extends SocketChannel> socketChannelClass() {
            this.socketChannelLatch.countDown();
            return super.socketChannelClass();
        }

        public EventLoopGroup createEventLoopGroup(int maxExecutors, ExecutorService executorService) {
            this.createEventLoopGroupLatch.countDown();
            return super.createEventLoopGroup(maxExecutors, executorService);
        }
    }
}

